/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.framework.dock.idw;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.border.Border;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.theme.DockingWindowsTheme;
import net.infonode.docking.util.PropertiesUtil;
import net.infonode.gui.colorprovider.ColorBlender;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.FixedColorProvider;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.gui.componentpainter.SolidColorComponentPainter;
import net.infonode.gui.shaped.border.RoundedCornerBorder;
import net.infonode.tabbedpanel.TabAreaProperties;
import org.apache.log4j.Logger;
import org.bbop.framework.dock.idw.BBOPTabTheme;

public class BBOPDockingTheme
extends DockingWindowsTheme {
    protected static final Logger logger = Logger.getLogger(BBOPDockingTheme.class);
    private RootWindowProperties rootWindowProperties = new RootWindowProperties();
    BBOPTabTheme theme;

    public BBOPDockingTheme(ColorProvider darkColor, ColorProvider lightColor, ColorProvider background, int cornerType, Font font) {
        this.configure(darkColor, lightColor, background, cornerType, font);
    }

    public void configure(Color darkColor, Color lightColor, Color backgroundColor, int cornerType, Font font) {
        this.configure((ColorProvider)new FixedColorProvider(darkColor), (ColorProvider)new FixedColorProvider(lightColor), (ColorProvider)new FixedColorProvider(backgroundColor), cornerType, font);
    }

    public void configure(ColorProvider darkColor, ColorProvider lightColor, ColorProvider backgroundColor, int cornerType, Font font) {
        this.theme = new BBOPTabTheme(darkColor, lightColor, this.rootWindowProperties.getComponentProperties().getFont(), cornerType);
        RootWindowProperties titleBarStyleProperties = PropertiesUtil.createTitleBarStyleRootWindowProperties();
        this.rootWindowProperties.addSuperObject(titleBarStyleProperties);
        this.rootWindowProperties.setRecursiveTabsEnabled(false);
        this.rootWindowProperties.getWindowAreaProperties().setBorder(null).setInsets(new Insets(2, 2, 2, 2));
        this.rootWindowProperties.getWindowAreaShapedPanelProperties().setComponentPainter((ComponentPainter)new SolidColorComponentPainter((ColorProvider)new ColorBlender(darkColor, lightColor, 0.5f)));
        this.rootWindowProperties.getTabWindowProperties().getTabbedPanelProperties().addSuperObject(this.theme.getTabbedPanelProperties());
        this.rootWindowProperties.getTabWindowProperties().getTabProperties().getTitledTabProperties().addSuperObject(this.theme.getTitledTabProperties());
        this.rootWindowProperties.getShapedPanelProperties().setComponentPainter(this.theme.getTabbedPanelProperties().getTabAreaProperties().getShapedPanelProperties().getComponentPainter());
        this.rootWindowProperties.getTabWindowProperties().getTabbedPanelProperties().getContentPanelProperties().getShapedPanelProperties().setClipChildren(true);
        this.rootWindowProperties.getViewProperties().getViewTitleBarProperties().getNormalProperties().getComponentProperties().setForegroundColor(Color.BLACK).setInsets(new Insets(0, 2, 0, 2)).setFont(font.deriveFont(1));
        this.rootWindowProperties.getViewProperties().getViewTitleBarProperties().getNormalProperties().getShapedPanelProperties().setComponentPainter((ComponentPainter)new SolidColorComponentPainter(backgroundColor)).setOpaque(false);
        this.rootWindowProperties.getViewProperties().getViewTitleBarProperties().getNormalProperties().getComponentProperties().setBorder((Border)new RoundedCornerBorder(null, lightColor, cornerType, cornerType, 0, 0, true, true, true, true));
        this.rootWindowProperties.getViewProperties().getViewTitleBarProperties().getFocusedProperties().getShapedPanelProperties().setComponentPainter((ComponentPainter)new SolidColorComponentPainter(darkColor));
        this.rootWindowProperties.getViewProperties().getViewTitleBarProperties().getFocusedProperties().getComponentProperties().setForegroundColor(Color.BLACK);
        TabAreaProperties p = this.rootWindowProperties.getWindowBarProperties().getTabWindowProperties().getTabbedPanelProperties().getTabAreaProperties();
        p.getShapedPanelProperties().setComponentPainter(null);
        p.getComponentProperties().setBorder(null);
        this.rootWindowProperties.getWindowBarProperties().getTabWindowProperties().getTabbedPanelProperties().getTabAreaComponentsProperties().getComponentProperties().setBorder(null);
        this.rootWindowProperties.getWindowBarProperties().getTabWindowProperties().getTabbedPanelProperties().getContentPanelProperties().getShapedPanelProperties().setOpaque(false);
    }

    public String getName() {
        return "Default BBOP Docking Theme";
    }

    public RootWindowProperties getRootWindowProperties() {
        return this.rootWindowProperties;
    }
}

