/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.framework.dock.idw;

import java.awt.Font;
import java.awt.Insets;
import javax.swing.border.Border;
import net.infonode.gui.colorprovider.ColorBlender;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.FixedColorProvider;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.gui.componentpainter.FixedTransformComponentPainter;
import net.infonode.gui.componentpainter.GradientComponentPainter;
import net.infonode.gui.shaped.border.RoundedCornerBorder;
import net.infonode.properties.base.Property;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.theme.TabbedPanelTitledTabTheme;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;
import net.infonode.util.Direction;
import org.apache.log4j.Logger;

public class BBOPTabTheme
extends TabbedPanelTitledTabTheme {
    protected static final Logger logger = Logger.getLogger(BBOPTabTheme.class);
    private TabbedPanelProperties tabbedPanelProperties = new TabbedPanelProperties();
    private TitledTabProperties titledTabProperties = new TitledTabProperties();

    public void configureLook(ColorProvider darkColor, ColorProvider lightColor, Font font) {
        this.configureLook(darkColor, lightColor, font, 4);
    }

    public void configureLook(ColorProvider darkColor, ColorProvider lightColor, Font font, int cornerType) {
        RoundedCornerBorder roundedBorder;
        RoundedCornerBorder tabNormalBorder = roundedBorder = new RoundedCornerBorder(darkColor, lightColor, cornerType, cornerType, 0, 0, true, true, true, true);
        RoundedCornerBorder contentBorder = new RoundedCornerBorder(darkColor, lightColor, cornerType, cornerType, cornerType, cornerType, false, true, true, true);
        this.setupGradient(darkColor, lightColor);
        this.tabbedPanelProperties.setPaintTabAreaShadow(true).setTabSpacing(2).setShadowEnabled(false);
        this.tabbedPanelProperties.getTabAreaProperties().getComponentProperties().setInsets(new Insets(2, 2, 3, 3));
        this.tabbedPanelProperties.getTabAreaComponentsProperties().setStretchEnabled(true).getComponentProperties().setBorder(null).setInsets(new Insets(0, 0, 0, 0));
        this.tabbedPanelProperties.getTabAreaComponentsProperties().getShapedPanelProperties().setOpaque(false);
        this.tabbedPanelProperties.getContentPanelProperties().getComponentProperties().setBorder((Border)contentBorder).setInsets(new Insets(3, 3, 4, 4));
        this.titledTabProperties.setHighlightedRaised(0);
        this.tabbedPanelProperties.setTabAreaOrientation(Direction.UP);
        if (font != null) {
            font = font.deriveFont(0).deriveFont(11.0f);
        }
        this.titledTabProperties.getNormalProperties().getComponentProperties().setBorder((Border)tabNormalBorder).setInsets(new Insets(1, 4, 2, 5)).setBackgroundColor(this.titledTabProperties.getHighlightedProperties().getComponentProperties().getBackgroundColor()).setFont(font);
        Property[] linkedProperties = new Property[]{ComponentProperties.BORDER, ComponentProperties.INSETS, ComponentProperties.FONT};
        for (int i = 0; i < linkedProperties.length; ++i) {
            this.titledTabProperties.getHighlightedProperties().getComponentProperties().getMap().createRelativeRef(linkedProperties[i], this.titledTabProperties.getNormalProperties().getComponentProperties().getMap(), linkedProperties[i]);
        }
    }

    private void setupGradient(ColorProvider darkColor, ColorProvider lightColor) {
        ColorBlender dark = new ColorBlender(darkColor, lightColor, 0.3f);
        ColorBlender dark2 = new ColorBlender(darkColor, (ColorProvider)FixedColorProvider.WHITE, 0.1f);
        FixedTransformComponentPainter highlightPainter = new FixedTransformComponentPainter((ComponentPainter)new GradientComponentPainter(darkColor, darkColor, darkColor, darkColor));
        this.titledTabProperties.getHighlightedProperties().getShapedPanelProperties().setComponentPainter((ComponentPainter)highlightPainter);
        FixedTransformComponentPainter contentPainter = new FixedTransformComponentPainter((ComponentPainter)new GradientComponentPainter(lightColor, (ColorProvider)dark2, (ColorProvider)dark2, lightColor));
        this.tabbedPanelProperties.getContentPanelProperties().getShapedPanelProperties().setComponentPainter((ComponentPainter)contentPainter).setClipChildren(true).setOpaque(false);
    }

    public BBOPTabTheme(ColorProvider darkColor, ColorProvider lightColor, Font font, int cornerType) {
        this.configureLook(darkColor, lightColor, font);
    }

    public String getName() {
        return "Default BBOP Tab Theme";
    }

    public TabbedPanelProperties getTabbedPanelProperties() {
        return this.tabbedPanelProperties;
    }

    public TitledTabProperties getTitledTabProperties() {
        return this.titledTabProperties;
    }
}

