/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.framework.dock.idw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.DockingWindowAdapter;
import net.infonode.docking.DockingWindowListener;
import net.infonode.docking.FloatingWindow;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.ViewSerializer;
import net.infonode.docking.WindowBar;
import net.infonode.docking.drag.DockingWindowDragSource;
import net.infonode.docking.drag.DockingWindowDragger;
import net.infonode.docking.drag.DockingWindowDraggerProvider;
import net.infonode.docking.mouse.DockingWindowActionMouseButtonListener;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.theme.BlueHighlightDockingTheme;
import net.infonode.docking.theme.ClassicDockingTheme;
import net.infonode.docking.theme.DefaultDockingTheme;
import net.infonode.docking.theme.DockingWindowsTheme;
import net.infonode.docking.theme.GradientDockingTheme;
import net.infonode.docking.theme.LookAndFeelDockingTheme;
import net.infonode.docking.theme.ShapedGradientDockingTheme;
import net.infonode.docking.theme.SlimFlatDockingTheme;
import net.infonode.docking.theme.SoftBlueIceDockingTheme;
import net.infonode.docking.util.AbstractViewMap;
import net.infonode.docking.util.DeveloperUtil;
import net.infonode.docking.util.DockingUtil;
import net.infonode.docking.util.MixedViewHandler;
import net.infonode.docking.util.PropertiesUtil;
import net.infonode.docking.util.ViewMap;
import net.infonode.gui.laf.InfoNodeLookAndFeel;
import net.infonode.util.Direction;
import org.apache.log4j.Logger;

public class DockingWindowsExample {
    protected static final Logger logger = Logger.getLogger(DockingWindowsExample.class);
    private static final int ICON_SIZE = 8;
    private static final Icon VIEW_ICON = new Icon(){

        public int getIconHeight() {
            return 8;
        }

        public int getIconWidth() {
            return 8;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color oldColor = g.getColor();
            g.setColor(new Color(70, 70, 70));
            g.fillRect(x, y, 8, 8);
            g.setColor(new Color(100, 230, 100));
            g.fillRect(x + 1, y + 1, 6, 6);
            g.setColor(oldColor);
        }
    };
    private static final Icon BUTTON_ICON = new Icon(){

        public int getIconHeight() {
            return 8;
        }

        public int getIconWidth() {
            return 8;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color oldColor = g.getColor();
            g.setColor(Color.BLACK);
            g.fillOval(x, y, 8, 8);
            g.setColor(oldColor);
        }
    };
    private RootWindow rootWindow;
    private View[] views = new View[10];
    private ViewMap viewMap = new ViewMap();
    private JMenuItem[] viewItems = new JMenuItem[this.views.length];
    private HashMap dynamicViews = new HashMap();
    private DockingWindowsTheme currentTheme = new ShapedGradientDockingTheme();
    private RootWindowProperties properties = new RootWindowProperties();
    private byte[][] layouts = new byte[3][];
    private JCheckBoxMenuItem enableMenuAndStatusLabelMenuItem = new JCheckBoxMenuItem("Add Menu Bar and Status Label to all New Floating Windows", true);
    private JFrame frame = new JFrame("InfoNode Docking Windows Example");

    public DockingWindowsExample() {
        this.createRootWindow();
        this.setDefaultLayout();
        this.showFrame();
    }

    private static JComponent createViewComponent(String text) {
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < 100; ++j) {
            sb.append(text + ". This is line " + j + "\n");
        }
        return new JScrollPane(new JTextArea(sb.toString()));
    }

    private View getDynamicView(int id) {
        View view = (View)this.dynamicViews.get(new Integer(id));
        if (view == null) {
            view = new DynamicView("Dynamic View " + id, VIEW_ICON, DockingWindowsExample.createViewComponent("Dynamic View " + id), id);
        }
        return view;
    }

    private int getDynamicViewId() {
        int id = 0;
        while (this.dynamicViews.containsKey(new Integer(id))) {
            ++id;
        }
        return id;
    }

    private void createRootWindow() {
        for (int i = 0; i < this.views.length; ++i) {
            this.views[i] = new View("View " + i, VIEW_ICON, (Component)DockingWindowsExample.createViewComponent("View " + i));
            this.viewMap.addView(i, this.views[i]);
        }
        JButton button = new JButton(BUTTON_ICON);
        button.setOpaque(false);
        button.setBorder(null);
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(DockingWindowsExample.this.frame, "You clicked the custom view button.", "Custom View Button", 1);
            }
        });
        this.views[2].getCustomTabComponents().add(button);
        MixedViewHandler handler = new MixedViewHandler((AbstractViewMap)this.viewMap, new ViewSerializer(){

            public void writeView(View view, ObjectOutputStream out) throws IOException {
                out.writeInt(((DynamicView)view).getId());
            }

            public View readView(ObjectInputStream in) throws IOException {
                return DockingWindowsExample.this.getDynamicView(in.readInt());
            }
        });
        this.rootWindow = DockingUtil.createRootWindow((AbstractViewMap)this.viewMap, (ViewSerializer)handler, (boolean)true);
        this.properties.addSuperObject(this.currentTheme.getRootWindowProperties());
        this.rootWindow.getRootWindowProperties().addSuperObject(this.properties);
        this.rootWindow.getWindowBar(Direction.DOWN).setEnabled(true);
        this.rootWindow.addListener((DockingWindowListener)new DockingWindowAdapter(){

            public void windowAdded(DockingWindow addedToWindow, DockingWindow addedWindow) {
                DockingWindowsExample.this.updateViews(addedWindow, true);
                if (addedWindow instanceof FloatingWindow) {
                    DockingWindowsExample.this.updateFloatingWindow((FloatingWindow)addedWindow);
                }
            }

            public void windowRemoved(DockingWindow removedFromWindow, DockingWindow removedWindow) {
                DockingWindowsExample.this.updateViews(removedWindow, false);
            }

            public void windowClosing(DockingWindow window) throws OperationAbortedException {
                if (JOptionPane.showConfirmDialog(DockingWindowsExample.this.frame, "Really close window '" + window + "'?") != 0) {
                    throw new OperationAbortedException("Window close was aborted!");
                }
            }

            public void windowDocking(DockingWindow window) throws OperationAbortedException {
                if (JOptionPane.showConfirmDialog(DockingWindowsExample.this.frame, "Really dock window '" + window + "'?") != 0) {
                    throw new OperationAbortedException("Window dock was aborted!");
                }
            }

            public void windowUndocking(DockingWindow window) throws OperationAbortedException {
                if (JOptionPane.showConfirmDialog(DockingWindowsExample.this.frame, "Really undock window '" + window + "'?") != 0) {
                    throw new OperationAbortedException("Window undock was aborted!");
                }
            }
        });
        this.rootWindow.addTabMouseButtonListener(DockingWindowActionMouseButtonListener.MIDDLE_BUTTON_CLOSE_LISTENER);
    }

    private void updateViews(DockingWindow window, boolean added) {
        if (window instanceof View) {
            if (window instanceof DynamicView) {
                if (added) {
                    this.dynamicViews.put(new Integer(((DynamicView)window).getId()), window);
                } else {
                    this.dynamicViews.remove(new Integer(((DynamicView)window).getId()));
                }
            } else {
                for (int i = 0; i < this.views.length; ++i) {
                    if (this.views[i] != window || this.viewItems[i] == null) continue;
                    this.viewItems[i].setEnabled(!added);
                }
            }
        } else {
            for (int i = 0; i < window.getChildWindowCount(); ++i) {
                this.updateViews(window.getChildWindow(i), added);
            }
        }
    }

    private void setDefaultLayout() {
        TabWindow tabWindow = new TabWindow((DockingWindow[])this.views);
        this.rootWindow.setWindow((DockingWindow)new SplitWindow(true, 0.3f, (DockingWindow)new SplitWindow(false, 0.7f, (DockingWindow)new TabWindow((DockingWindow[])new View[]{this.views[0], this.views[1]}), (DockingWindow)this.views[2]), (DockingWindow)tabWindow));
        WindowBar windowBar = this.rootWindow.getWindowBar(Direction.DOWN);
        while (windowBar.getChildWindowCount() > 0) {
            windowBar.getChildWindow(0).close();
        }
        windowBar.addTab((DockingWindow)this.views[3]);
    }

    private void showFrame() {
        this.frame.getContentPane().add((Component)this.createToolBar(), "North");
        this.frame.getContentPane().add((Component)this.rootWindow, "Center");
        this.frame.setJMenuBar(this.createMenuBar());
        this.frame.setSize(900, 700);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setVisible(true);
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        JLabel label = new JLabel("Drag New View");
        toolBar.add(label);
        new DockingWindowDragSource((JComponent)label, new DockingWindowDraggerProvider(){

            public DockingWindowDragger getDragger(MouseEvent mouseEvent) {
                return DockingWindowsExample.this.getDynamicView(DockingWindowsExample.this.getDynamicViewId()).startDrag(DockingWindowsExample.this.rootWindow);
            }
        });
        return toolBar;
    }

    private JMenuBar createMenuBar() {
        JMenuBar menu = new JMenuBar();
        menu.add(this.createLayoutMenu());
        menu.add(this.createFocusViewMenu());
        menu.add(this.createThemesMenu());
        menu.add(this.createPropertiesMenu());
        menu.add(this.createWindowBarsMenu());
        menu.add(this.createViewMenu());
        menu.add(this.createFloatingWindowMenu());
        return menu;
    }

    private JMenu createLayoutMenu() {
        int j;
        int i;
        JMenu layoutMenu = new JMenu("Layout");
        layoutMenu.add("Default Layout").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DockingWindowsExample.this.setDefaultLayout();
            }
        });
        layoutMenu.addSeparator();
        for (i = 0; i < this.layouts.length; ++i) {
            j = i;
            layoutMenu.add("Save Layout " + i).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        ObjectOutputStream out = new ObjectOutputStream(bos);
                        DockingWindowsExample.this.rootWindow.write(out, false);
                        out.close();
                        ((DockingWindowsExample)DockingWindowsExample.this).layouts[j] = bos.toByteArray();
                    }
                    catch (IOException e1) {
                        throw new RuntimeException(e1);
                    }
                }
            });
        }
        layoutMenu.addSeparator();
        i = 0;
        while (i < this.layouts.length) {
            j = i++;
            layoutMenu.add("Load Layout " + j).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (DockingWindowsExample.this.layouts[j] != null) {
                                try {
                                    ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(DockingWindowsExample.this.layouts[j]));
                                    DockingWindowsExample.this.rootWindow.read(in, true);
                                    in.close();
                                }
                                catch (IOException e1) {
                                    throw new RuntimeException(e1);
                                }
                            }
                        }
                    });
                }
            });
        }
        layoutMenu.addSeparator();
        layoutMenu.add("Show Window Layout Frame").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeveloperUtil.createWindowLayoutFrame((String)"Root Window Layout as Java Pseudo-like Code", (DockingWindow)DockingWindowsExample.this.rootWindow).setVisible(true);
            }
        });
        return layoutMenu;
    }

    private JMenu createFocusViewMenu() {
        JMenu viewsMenu = new JMenu("Focus View");
        for (int i = 0; i < this.views.length; ++i) {
            final View view = this.views[i];
            viewsMenu.add("Focus " + view.getTitle()).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DockingUtil.addWindow((DockingWindow)view, (RootWindow)DockingWindowsExample.this.rootWindow);
                            view.restoreFocus();
                        }
                    });
                }
            });
        }
        return viewsMenu;
    }

    private JMenu createThemesMenu() {
        JMenu themesMenu = new JMenu("Themes");
        final RootWindowProperties titleBarStyleProperties = PropertiesUtil.createTitleBarStyleRootWindowProperties();
        final JCheckBoxMenuItem titleBarStyleItem = new JCheckBoxMenuItem("Title Bar Style Theme");
        titleBarStyleItem.setSelected(false);
        titleBarStyleItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (titleBarStyleItem.isSelected()) {
                    DockingWindowsExample.this.properties.addSuperObject(titleBarStyleProperties);
                } else {
                    DockingWindowsExample.this.properties.removeSuperObject(titleBarStyleProperties);
                }
            }
        });
        themesMenu.add(titleBarStyleItem);
        themesMenu.add(new JSeparator());
        DockingWindowsTheme[] themes = new DockingWindowsTheme[]{new DefaultDockingTheme(), new LookAndFeelDockingTheme(), new BlueHighlightDockingTheme(), new SlimFlatDockingTheme(), new GradientDockingTheme(), new ShapedGradientDockingTheme(), new SoftBlueIceDockingTheme(), new ClassicDockingTheme()};
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < themes.length; ++i) {
            final DockingWindowsTheme theme = themes[i];
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(theme.getName());
            item.setSelected(i == 4);
            group.add(item);
            themesMenu.add(item).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DockingWindowsExample.this.properties.getMap().clear(true);
                    DockingWindowsExample.this.setTheme(theme);
                }
            });
        }
        return themesMenu;
    }

    private JMenu createPropertiesMenu() {
        JMenu buttonsMenu = new JMenu("Properties");
        buttonsMenu.add("Enable Close").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DockingWindowsExample.this.properties.getDockingWindowProperties().setCloseEnabled(true);
            }
        });
        buttonsMenu.add("Hide Close Buttons").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DockingWindowsExample.this.properties.getDockingWindowProperties().setCloseEnabled(false);
            }
        });
        buttonsMenu.add("Freeze Layout").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DockingWindowsExample.this.freezeLayout(true);
            }
        });
        buttonsMenu.add("Unfreeze Layout").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DockingWindowsExample.this.freezeLayout(false);
            }
        });
        return buttonsMenu;
    }

    private void freezeLayout(boolean freeze) {
        this.properties.getDockingWindowProperties().setDragEnabled(!freeze);
        this.properties.getDockingWindowProperties().setCloseEnabled(!freeze);
        this.properties.getDockingWindowProperties().setMinimizeEnabled(!freeze);
        this.properties.getDockingWindowProperties().setRestoreEnabled(!freeze);
        this.properties.getDockingWindowProperties().setMaximizeEnabled(!freeze);
        this.properties.getDockingWindowProperties().setUndockEnabled(!freeze);
        this.properties.getDockingWindowProperties().setDockEnabled(!freeze);
        this.properties.getTabWindowProperties().getTabbedPanelProperties().setTabReorderEnabled(!freeze);
    }

    private JMenu createWindowBarsMenu() {
        JMenu barsMenu = new JMenu("Window Bars");
        for (int i = 0; i < 4; ++i) {
            final Direction d = Direction.getDirections()[i];
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Toggle " + d);
            item.setSelected(d == Direction.DOWN);
            barsMenu.add(item).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DockingWindowsExample.this.rootWindow.getWindowBar(d).setEnabled(!DockingWindowsExample.this.rootWindow.getWindowBar(d).isEnabled());
                }
            });
        }
        return barsMenu;
    }

    private JMenu createViewMenu() {
        JMenu menu = new JMenu("Views");
        for (int i = 0; i < this.views.length; ++i) {
            final View view = this.views[i];
            this.viewItems[i] = new JMenuItem(view.getTitle());
            this.viewItems[i].setEnabled(this.views[i].getRootWindow() == null);
            menu.add(this.viewItems[i]).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (view.getRootWindow() != null) {
                        view.restoreFocus();
                    } else {
                        DockingUtil.addWindow((DockingWindow)view, (RootWindow)DockingWindowsExample.this.rootWindow);
                    }
                }
            });
        }
        return menu;
    }

    private JMenu createFloatingWindowMenu() {
        JMenu menu = new JMenu("Floating Window");
        menu.add(this.enableMenuAndStatusLabelMenuItem);
        JMenuItem item1 = new JMenuItem("Create Floating Window with Dynamic View");
        item1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FloatingWindow fw = DockingWindowsExample.this.rootWindow.createFloatingWindow(new Point(50, 50), new Dimension(300, 200), (DockingWindow)DockingWindowsExample.this.getDynamicView(DockingWindowsExample.this.getDynamicViewId()));
                fw.getTopLevelAncestor().setVisible(true);
            }
        });
        menu.add(item1);
        return menu;
    }

    private void updateFloatingWindow(FloatingWindow fw) {
        if (this.enableMenuAndStatusLabelMenuItem.isSelected()) {
            JMenuBar bar = new JMenuBar();
            bar.add(new JMenu("Menu 1")).add(new JMenuItem("Menu 1 Item 1"));
            bar.add(new JMenu("Menu 2")).add(new JMenuItem("Menu 2 Item 1"));
            fw.getRootPane().setJMenuBar(bar);
            JLabel statusLabel = new JLabel("I'm a status label!");
            fw.getRootPane().getContentPane().add((Component)statusLabel, "South");
        }
    }

    private void setTheme(DockingWindowsTheme theme) {
        this.properties.replaceSuperObject(this.currentTheme.getRootWindowProperties(), theme.getRootWindowProperties());
        this.currentTheme = theme;
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel((LookAndFeel)new InfoNodeLookAndFeel());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new DockingWindowsExample();
            }
        });
    }

    private static class DynamicView
    extends View {
        private int id;

        DynamicView(String title, Icon icon, Component component, int id) {
            super(title, icon, component);
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

