/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.bbop.io.ProgressableFileInputStream;
import org.bbop.io.ProgressableInputStream;
import org.bbop.io.ProgressableURLInputStream;

public final class IOUtil {
    public static void copyFile(File in, File out) throws IOException {
        Logger logger = Logger.getLogger(IOUtil.class);
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public static String readFileToPosition(String uri, int pos) {
        try {
            int c;
            BufferedInputStream s = new BufferedInputStream(IOUtil.getStream(uri));
            StringBuffer out = new StringBuffer();
            int byteCount = 0;
            while ((c = ((InputStream)s).read()) != -1) {
                out.append((char)c);
                if (pos < 0 || ++byteCount < pos) continue;
            }
            ((InputStream)s).close();
            return out.toString();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static String readFile(String uri) {
        return IOUtil.readFileToPosition(uri, -1);
    }

    public static long calculateChecksum(InputStream stream) throws IOException {
        int read;
        CRC32 crc32 = new CRC32();
        while ((read = stream.read()) != -1) {
            crc32.update(read);
        }
        return crc32.getValue();
    }

    public static File createTempDir(String name, String ext) throws Exception {
        File f = File.createTempFile(name, ext);
        f.delete();
        f.mkdirs();
        return f;
    }

    public static void deltreeOnExit(final File file) throws IOException {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    IOUtil.deltree(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static void deltree(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] children = file.list();
            for (int i = 0; i < children.length; ++i) {
                IOUtil.deltree(new File(file, children[i]));
            }
            file.delete();
        } else if (file.isFile()) {
            file.delete();
        }
    }

    public static void main(String[] args) throws Exception {
        ZipFile f = new ZipFile(new File(args[0]));
        File tempDir = IOUtil.createTempDir("archive", ".dir");
        File outFile = new File("/home/jrichter/zip");
        IOUtil.unzip(outFile, f);
        IOUtil.deltree(outFile);
    }

    public static void unzip(File targetDir, File file) throws IOException {
        IOUtil.unzip(targetDir, new ZipFile(file));
    }

    public static void unzip(File targetDir, ZipFile file) throws IOException {
        Enumeration<? extends ZipEntry> e = file.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory()) {
                File dir = new File(entry.getName());
                dir.mkdirs();
                continue;
            }
            File outFile = new File(targetDir, entry.getName());
            if (outFile.getParentFile() != null) {
                outFile.getParentFile().mkdirs();
            }
            BufferedInputStream istream = new BufferedInputStream(file.getInputStream(entry));
            BufferedOutputStream ostream = new BufferedOutputStream(new FileOutputStream(outFile));
            IOUtil.dumpAndClose(istream, ostream);
        }
    }

    public static void dumpAndClose(InputStream istream, OutputStream ostream) throws IOException {
        int read;
        while ((read = istream.read()) != -1) {
            ostream.write((byte)read);
        }
        istream.close();
        ostream.close();
    }

    public static ProgressableInputStream getProgressableStream(String uri) throws IOException {
        File file = new File(uri);
        Object pathStr = null;
        if (file.exists()) {
            return new ProgressableFileInputStream(file);
        }
        URL url = null;
        try {
            url = new URL(uri);
            return new ProgressableURLInputStream(url);
        }
        catch (MalformedURLException ex) {
            throw new IOException("Invalid path " + uri);
        }
    }

    public static InputStream getStream(String uri) throws IOException {
        InputStream stream;
        File file = new File(uri);
        String pathStr = null;
        if (file.exists()) {
            stream = new FileInputStream(file);
            pathStr = file.toString();
        } else {
            URL url = null;
            try {
                url = new URL(uri);
            }
            catch (MalformedURLException ex) {
                throw new IOException("Invalid path " + uri);
            }
            pathStr = url.toString();
            stream = url.openStream();
        }
        return new BufferedInputStream(stream);
    }

    public static String getShortName(String path) {
        URL url = IOUtil.getURL(path);
        if (url == null) {
            return null;
        }
        File file = new File(url.getPath());
        return file.getName();
    }

    public static URL getURL(String path) {
        try {
            URL url = new URL(path);
            File file = new File(path);
            if (file.exists()) {
                return new URL("file:" + file.getCanonicalPath());
            }
            return url;
        }
        catch (MalformedURLException e) {
            try {
                File file = new File(path);
                return new URL("file:" + file.getCanonicalPath());
            }
            catch (MalformedURLException ex) {
                return null;
            }
            catch (IOException ex) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean isURL(String path) {
        try {
            URL url = new URL(path);
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public static void copyFiles(File src, File dest) throws IOException {
        if (!src.exists()) {
            throw new IOException("copyFiles: Can not find source: " + src.getAbsolutePath() + ".");
        }
        if (!src.canRead()) {
            throw new IOException("copyFiles: No right to source: " + src.getAbsolutePath() + ".");
        }
        if (src.isDirectory()) {
            if (!dest.exists() && !dest.mkdirs()) {
                throw new IOException("copyFiles: Could not create direcotry: " + dest.getAbsolutePath() + ".");
            }
            String[] list = src.list();
            for (int i = 0; i < list.length; ++i) {
                File dest1 = new File(dest, list[i]);
                File src1 = new File(src, list[i]);
                IOUtil.copyFiles(src1, dest1);
            }
        } else {
            try {
                System.out.println("copyFile " + src + " -> " + dest);
                IOUtil.copyFile(src, dest);
            }
            catch (IOException e) {
                IOException wrapper = new IOException("copyFiles: Unable to copy file: " + src.getAbsolutePath() + "to" + dest.getAbsolutePath() + ".");
                wrapper.initCause(e);
                wrapper.setStackTrace(e.getStackTrace());
                throw wrapper;
            }
        }
    }
}

