/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.bbop.util.ProgressValued;

public abstract class ProgressableInputStream
extends InputStream
implements ProgressValued {
    protected long fileSize = 0L;
    protected long currentPos = 0L;
    protected double currentProgress = 0.0;
    protected double percentInc = 1.0;
    protected Vector listeners = new Vector();
    protected String progressMessage = "Reading...";
    protected InputStream stream;

    public String getProgressString() {
        return this.progressMessage;
    }

    public Number getProgressValue() {
        return 100.0 * (double)this.currentPos / (double)this.fileSize;
    }

    protected void setStream(InputStream stream) {
        this.stream = stream;
    }

    protected void setStreamSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public void setPercentIncrement(double percent) {
        this.percentInc = percent;
    }

    public double getPercentIncremement() {
        return this.percentInc;
    }

    public void setProgressMessage(String message) {
        this.progressMessage = message;
    }

    public int read() throws IOException {
        ++this.currentPos;
        return this.stream.read();
    }

    public int read(byte[] bytes) throws IOException {
        int amtread = this.stream.read(bytes);
        this.currentPos += (long)amtread;
        return amtread;
    }

    public int read(byte[] bytes, int off, int len) throws IOException {
        int amtread = this.stream.read(bytes, off, len);
        this.currentPos += (long)amtread;
        return amtread;
    }

    public long skip(long amt) throws IOException {
        long amtskipped = this.stream.skip(amt);
        this.currentPos += amtskipped;
        return amtskipped;
    }

    public int available() throws IOException {
        return this.stream.available();
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public void mark(int readLimit) {
        this.stream.mark(readLimit);
    }

    public void reset() throws IOException {
        this.stream.reset();
    }

    public boolean markSupported() {
        return this.stream.markSupported();
    }
}

