/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.rdbms.impl;

import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.bbop.rdbms.ConstraintSet;
import org.bbop.rdbms.RelationalTerm;
import org.bbop.rdbms.WhereClause;
import org.bbop.rdbms.impl.AbstractRelationalTerm;
import org.bbop.rdbms.impl.SqlSimpleTerm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlConstraintSetImpl
extends AbstractRelationalTerm
implements ConstraintSet {
    protected static final Logger logger = Logger.getLogger(SqlConstraintSetImpl.class);
    protected LinkedList<RelationalTerm> constraints = new LinkedList();
    protected WhereClause.BooleanOperator operator = WhereClause.BooleanOperator.AND;

    @Override
    public LinkedList<RelationalTerm> getConstraints() {
        return this.constraints;
    }

    @Override
    public WhereClause.BooleanOperator getOperator() {
        return this.operator;
    }

    @Override
    public void setOperator(WhereClause.BooleanOperator operator) {
        this.operator = operator;
    }

    @Override
    public boolean isEmpty() {
        return this.getConstraints().size() == 0;
    }

    @Override
    public void setConstraints(LinkedList<String> terms) {
        this.constraints = new LinkedList();
        for (String s : terms) {
            this.constraints.add(new SqlSimpleTerm(s));
        }
    }

    @Override
    public void addConstraint(String s) {
        this.constraints.add(new SqlSimpleTerm(s));
    }

    @Override
    public void addEqualityConstraint(String s, Object o) {
        this.constraints.add(new SqlSimpleTerm(s + "=" + o));
    }

    @Override
    public String toSQL() {
        StringBuffer sb = new StringBuffer();
        int n = 0;
        for (RelationalTerm c : this.constraints) {
            if (n > 0) {
                sb.append(" " + (Object)((Object)this.operator) + " ");
            }
            ++n;
            sb.append(c.toSQL());
        }
        return sb.toString();
    }

    @Override
    public void addConstraint(WhereClause subClause) {
        this.constraints.add(subClause);
    }
}

