/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Shape;
import java.awt.geom.Point2D;
import org.bbop.swing.PathOp;
import org.bbop.swing.PathOpList;
import org.bbop.swing.ShapeExtender;

public abstract class AbstractShapeExtender
implements ShapeExtender {
    public Shape[] extend(Shape a, Shape b) {
        int endTargetIndex;
        int endSourceIndex;
        int i;
        Shape[] out = new Shape[2];
        PathOpList source = new PathOpList(a, false);
        PathOpList target = new PathOpList(b, false);
        int[] sourceIndices = source.getSubpathIndices(false);
        int[] targetIndices = target.getSubpathIndices(false);
        for (i = 0; i < sourceIndices.length && i < targetIndices.length; ++i) {
            PathOp newEndOp;
            endSourceIndex = i >= sourceIndices.length - 1 ? source.size() - 1 : sourceIndices[i + 1] - 1;
            endTargetIndex = i >= targetIndices.length - 1 ? target.size() - 1 : targetIndices[i + 1] - 1;
            PathOp endTargetOp = target.getSegment(endTargetIndex);
            PathOp endSourceOp = source.getSegment(endSourceIndex);
            if (endTargetOp.getOp() == 4 && endTargetOp.getOp() != endSourceOp.getOp()) {
                source.addPendingOp(endSourceIndex + 1, new PathOp(4, null));
                continue;
            }
            if (endSourceOp.getOp() != 4 || endTargetOp.getOp() == endSourceOp.getOp()) continue;
            PathOp sourceStartOp = source.getSegment(sourceIndices[i]);
            if (sourceStartOp.getOp() == 0) {
                newEndOp = new PathOp(1, sourceStartOp.getCoords());
            } else {
                float[] coords = new float[]{0.0f, 0.0f};
                newEndOp = new PathOp(1, coords);
            }
            source.resetOp(endSourceIndex, newEndOp);
        }
        source.flushPendingOps();
        target.flushPendingOps();
        sourceIndices = source.getSubpathIndices(true);
        targetIndices = target.getSubpathIndices(true);
        for (i = 0; i < sourceIndices.length && i < targetIndices.length; ++i) {
            endSourceIndex = i >= sourceIndices.length - 1 ? source.size() - 1 : sourceIndices[i + 1] - 1;
            endTargetIndex = i >= targetIndices.length - 1 ? target.size() - 1 : targetIndices[i + 1] - 1;
            this.addPoints(source, sourceIndices[i], endSourceIndex, target, targetIndices[i], endTargetIndex);
        }
        source.flushPendingOps();
        target.flushPendingOps();
        if (i < sourceIndices.length) {
            this.appendEmptySubpaths(target, source, sourceIndices, sourceIndices.length - targetIndices.length);
        } else if (i < targetIndices.length) {
            this.appendEmptySubpaths(source, target, targetIndices, targetIndices.length - sourceIndices.length);
        }
        out[0] = source.getShape();
        out[1] = target.getShape();
        return out;
    }

    protected void appendEmptySubpaths(PathOpList target, PathOpList source, int[] sourceIndices, int subpathCount) {
        int startIndex;
        Point2D.Float origin = target.size() == 0 ? new Point2D.Float() : target.getSegmentEndpoint(target.size() - 1, null);
        for (int i = startIndex = sourceIndices[sourceIndices.length - subpathCount]; i < source.size(); ++i) {
            PathOp newOp;
            float[] coords;
            PathOp op = source.getSegment(i);
            if (op.op == 0) {
                coords = new float[]{origin.x, origin.y};
                newOp = new PathOp(op.op, coords);
                target.addPendingOp(-1, newOp);
                continue;
            }
            if (op.op == 4) {
                newOp = new PathOp(op.op, new float[0]);
                target.addPendingOp(-1, newOp);
                continue;
            }
            coords = new float[]{origin.x, origin.y};
            newOp = new PathOp(1, coords);
            target.addPendingOp(-1, newOp);
        }
        try {
            target.flushPendingOps();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    protected abstract void addPoints(PathOpList var1, int var2, int var3, PathOpList var4, int var5, int var6);
}

