/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.bbop.util.VectorFilter;

public class AutoScrollSpec {
    protected static final Logger logger = Logger.getLogger(AutoScrollSpec.class);
    protected boolean doAutoscroll;
    protected JViewport viewport;
    protected Component component;
    protected Insets insets;
    protected int scrollInterval;
    protected int scrollDistance;
    protected VectorFilter scrollAllower;

    public AutoScrollSpec(Component component) {
        this(component, AutoScrollSpec.getViewportForComponent(component), null, new Insets(10, 10, 10, 10), 50, 10, true);
    }

    protected static JViewport getViewportForComponent(Component c) {
        return (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, c);
    }

    public AutoScrollSpec(Component component, JViewport viewport, VectorFilter scrollAllower, Insets insets, int scrollInterval, int scrollDistance, boolean doAutoscroll) {
        this.component = component;
        this.doAutoscroll = doAutoscroll;
        this.scrollAllower = scrollAllower;
        this.scrollInterval = scrollInterval;
        this.scrollDistance = scrollDistance;
        this.viewport = viewport;
        this.insets = insets;
    }

    public boolean allowScroll(MouseEvent o) {
        return this.doAutoscroll && (this.scrollAllower == null || this.scrollAllower != null && this.scrollAllower.satisfies(o));
    }

    public VectorFilter getScrollAllower() {
        return this.scrollAllower;
    }

    public void setScrollAllower(VectorFilter scrollAllower) {
        this.scrollAllower = scrollAllower;
    }

    public void setViewport(JViewport viewport) {
        this.viewport = viewport;
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public Component getComponent() {
        return this.component;
    }

    public int getScrollDistance() {
        return this.scrollDistance;
    }

    public void setScrollDistance(int scrollDistance) {
        this.scrollDistance = scrollDistance;
    }

    public int getScrollInterval() {
        return this.scrollInterval;
    }

    public void setScrollInterval(int scrollInterval) {
        this.scrollInterval = scrollInterval;
    }

    public void setAutoscrollEnabled(boolean doAutoscroll) {
        this.doAutoscroll = doAutoscroll;
    }

    public boolean getAutoscrollEnabled() {
        return this.doAutoscroll;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public Insets getInsets() {
        return this.insets;
    }
}

