/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.apache.log4j.Logger;
import org.bbop.swing.BackgroundEventQueue;
import org.bbop.util.AbstractTaskDelegate;
import org.bbop.util.TaskDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackgroundUtil {
    protected static final Logger logger = Logger.getLogger(BackgroundUtil.class);

    private BackgroundUtil() {
    }

    public static void scheduleTask(TaskDelegate<?> task) {
        BackgroundUtil.scheduleTasks(task);
    }

    public static void scheduleTask(BackgroundEventQueue queue, TaskDelegate<?> task, boolean block, String blockMessage) {
        BackgroundUtil.scheduleTasks(queue, block, blockMessage, task);
    }

    public static void scheduleTasks(TaskDelegate<?> ... tasks) {
        BackgroundUtil.scheduleTasks(BackgroundEventQueue.getGlobalQueue(), false, null, tasks);
    }

    public static void scheduleTasks(BackgroundEventQueue queue, boolean block, String blockMessage, TaskDelegate<?> ... tasks) {
        JDialog dialog = null;
        if (block) {
            dialog = new JDialog((Frame)null, true);
            tasks = BackgroundUtil.getBlockingTasks(tasks, dialog, blockMessage);
        }
        queue.scheduleTasks(tasks);
        if (block) {
            BackgroundUtil.block(dialog);
        }
    }

    protected static TaskDelegate<?>[] getBlockingTasks(TaskDelegate<?>[] tasks, JDialog dialog, String blockMessage) {
        dialog.setTitle(blockMessage);
        dialog.getContentPane().add(new JLabel(blockMessage));
        dialog.setLocation(0, 0);
        TaskDelegate[] newTasks = new TaskDelegate[tasks.length + 1];
        for (int i = 0; i < tasks.length; ++i) {
            newTasks[i] = tasks[i];
        }
        final JDialog fdialog = dialog;
        AbstractTaskDelegate<Void> finishTask = new AbstractTaskDelegate<Void>(){

            @Override
            public void execute() throws Exception {
            }
        };
        finishTask.setSwingFriendly(true);
        Runnable post = new Runnable(){

            public void run() {
                fdialog.setVisible(false);
                fdialog.dispose();
            }
        };
        finishTask.addPostExecuteRunnable(post);
        finishTask.addCancelledRunnable(post);
        finishTask.addFailedRunnable(post);
        newTasks[tasks.length] = finishTask;
        return newTasks;
    }

    protected static void block(JDialog dialog) {
        dialog.pack();
        dialog.setVisible(true);
        dialog.toFront();
    }

    public static void scheduleDependentTasks(TaskDelegate<?> ... tasks) {
        BackgroundUtil.scheduleDependentTasks(BackgroundEventQueue.getGlobalQueue(), false, null, tasks);
    }

    public static void scheduleDependentTasks(BackgroundEventQueue queue, boolean block, String blockMessage, TaskDelegate<?> ... tasks) {
        queue.scheduleDependentTasks(tasks);
    }
}

