/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import org.apache.log4j.Logger;

public class BlockingProgressMonitor
implements Accessible {
    protected static final Logger logger = Logger.getLogger(BlockingProgressMonitor.class);
    private ProgressMonitor root;
    private JDialog dialog;
    private JOptionPane pane;
    private JProgressBar myBar;
    private JLabel noteLabel;
    private Component parentComponent;
    private String note;
    private Object[] cancelOption = null;
    private Object message;
    private long T0;
    private int millisToDecideToPopup = 0;
    private int millisToPopup = 0;
    private int min;
    private int max;
    protected AccessibleContext accessibleContext = null;
    private AccessibleContext accessibleJOptionPane = null;

    public BlockingProgressMonitor(Component parentComponent, Object message, String note, int min, int max) {
        this.min = min;
        this.max = max;
        this.parentComponent = parentComponent;
        this.cancelOption = new Object[1];
        this.cancelOption[0] = UIManager.getString("OptionPane.cancelButtonText");
        this.message = message;
        this.note = note;
        this.T0 = System.currentTimeMillis();
    }

    public void setProgress(int nv) {
        if (nv >= this.max) {
            this.close();
        } else if (this.myBar != null) {
            this.myBar.setValue(nv);
        } else {
            int predictedCompletionTime;
            long T = System.currentTimeMillis();
            long dT = (int)(T - this.T0);
            if (dT >= (long)this.millisToDecideToPopup && (predictedCompletionTime = nv > this.min ? (int)(dT * (long)(this.max - this.min) / (long)(nv - this.min)) : this.millisToPopup) >= this.millisToPopup) {
                this.myBar = new JProgressBar();
                this.myBar.setMinimum(this.min);
                this.myBar.setMaximum(this.max);
                this.myBar.setValue(nv);
                if (this.note != null) {
                    this.noteLabel = new JLabel(this.note);
                }
                this.pane = new ProgressOptionPane(new Object[]{this.message, this.noteLabel, this.myBar});
                logger.info((Object)"shutting down windows!");
                this.dialog = this.pane.createDialog(this.parentComponent, UIManager.getString("ProgressMonitor.progressText"));
                this.dialog.show();
            }
        }
    }

    public void close() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
            this.pane = null;
            this.myBar = null;
        }
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int m) {
        if (this.myBar != null) {
            this.myBar.setMinimum(m);
        }
        this.min = m;
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int m) {
        if (this.myBar != null) {
            this.myBar.setMaximum(m);
        }
        this.max = m;
    }

    public boolean isCanceled() {
        if (this.pane == null) {
            return false;
        }
        Object v = this.pane.getValue();
        return v != null && this.cancelOption.length == 1 && v.equals(this.cancelOption[0]);
    }

    public void setMillisToDecideToPopup(int millisToDecideToPopup) {
        this.millisToDecideToPopup = millisToDecideToPopup;
    }

    public int getMillisToDecideToPopup() {
        return this.millisToDecideToPopup;
    }

    public void setMillisToPopup(int millisToPopup) {
        this.millisToPopup = millisToPopup;
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    public void setNote(String note) {
        this.note = note;
        if (this.noteLabel != null) {
            this.noteLabel.setText(note);
        }
    }

    public String getNote() {
        return this.note;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleProgressMonitor();
        }
        if (this.pane != null && this.accessibleJOptionPane == null && this.accessibleContext instanceof AccessibleProgressMonitor) {
            ((AccessibleProgressMonitor)this.accessibleContext).optionPaneCreated();
        }
        return this.accessibleContext;
    }

    protected class AccessibleProgressMonitor
    extends AccessibleContext
    implements AccessibleText,
    ChangeListener,
    PropertyChangeListener {
        private Object oldModelValue;

        protected AccessibleProgressMonitor() {
        }

        private void optionPaneCreated() {
            BlockingProgressMonitor.this.accessibleJOptionPane = ((ProgressOptionPane)BlockingProgressMonitor.this.pane).getAccessibleJOptionPane();
            if (BlockingProgressMonitor.this.myBar != null) {
                BlockingProgressMonitor.this.myBar.addChangeListener(this);
            }
            if (BlockingProgressMonitor.this.noteLabel != null) {
                BlockingProgressMonitor.this.noteLabel.addPropertyChangeListener(this);
            }
        }

        public void stateChanged(ChangeEvent e) {
            if (e == null) {
                return;
            }
            if (BlockingProgressMonitor.this.myBar != null) {
                Integer newModelValue = BlockingProgressMonitor.this.myBar.getValue();
                this.firePropertyChange("AccessibleValue", this.oldModelValue, newModelValue);
                this.oldModelValue = newModelValue;
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == BlockingProgressMonitor.this.noteLabel && e.getPropertyName() == "text") {
                this.firePropertyChange("AccessibleText", null, 0);
            }
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (BlockingProgressMonitor.this.accessibleJOptionPane != null) {
                return BlockingProgressMonitor.this.accessibleJOptionPane.getAccessibleName();
            }
            return null;
        }

        public String getAccessibleDescription() {
            if (this.accessibleDescription != null) {
                return this.accessibleDescription;
            }
            if (BlockingProgressMonitor.this.accessibleJOptionPane != null) {
                return BlockingProgressMonitor.this.accessibleJOptionPane.getAccessibleDescription();
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PROGRESS_MONITOR;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            if (BlockingProgressMonitor.this.accessibleJOptionPane != null) {
                return BlockingProgressMonitor.this.accessibleJOptionPane.getAccessibleStateSet();
            }
            return null;
        }

        public Accessible getAccessibleParent() {
            if (BlockingProgressMonitor.this.dialog != null) {
                return BlockingProgressMonitor.this.dialog;
            }
            return null;
        }

        private AccessibleContext getParentAccessibleContext() {
            if (BlockingProgressMonitor.this.dialog != null) {
                return BlockingProgressMonitor.this.dialog.getAccessibleContext();
            }
            return null;
        }

        public int getAccessibleIndexInParent() {
            if (BlockingProgressMonitor.this.accessibleJOptionPane != null) {
                return BlockingProgressMonitor.this.accessibleJOptionPane.getAccessibleIndexInParent();
            }
            return -1;
        }

        public int getAccessibleChildrenCount() {
            AccessibleContext ac = this.getPanelAccessibleContext();
            if (ac != null) {
                return ac.getAccessibleChildrenCount();
            }
            return 0;
        }

        public Accessible getAccessibleChild(int i) {
            AccessibleContext ac = this.getPanelAccessibleContext();
            if (ac != null) {
                return ac.getAccessibleChild(i);
            }
            return null;
        }

        private AccessibleContext getPanelAccessibleContext() {
            Container c;
            if (BlockingProgressMonitor.this.myBar != null && (c = BlockingProgressMonitor.this.myBar.getParent()) instanceof Accessible) {
                return ((Accessible)((Object)c)).getAccessibleContext();
            }
            return null;
        }

        public Locale getLocale() throws IllegalComponentStateException {
            if (BlockingProgressMonitor.this.accessibleJOptionPane != null) {
                return BlockingProgressMonitor.this.accessibleJOptionPane.getLocale();
            }
            return null;
        }

        public AccessibleComponent getAccessibleComponent() {
            if (BlockingProgressMonitor.this.accessibleJOptionPane != null) {
                return BlockingProgressMonitor.this.accessibleJOptionPane.getAccessibleComponent();
            }
            return null;
        }

        public AccessibleValue getAccessibleValue() {
            if (BlockingProgressMonitor.this.myBar != null) {
                return BlockingProgressMonitor.this.myBar.getAccessibleContext().getAccessibleValue();
            }
            return null;
        }

        public AccessibleText getAccessibleText() {
            if (this.getNoteLabelAccessibleText() != null) {
                return this;
            }
            return null;
        }

        private AccessibleText getNoteLabelAccessibleText() {
            if (BlockingProgressMonitor.this.noteLabel != null) {
                return BlockingProgressMonitor.this.noteLabel.getAccessibleContext().getAccessibleText();
            }
            return null;
        }

        public int getIndexAtPoint(Point p) {
            Point noteLabelPoint;
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null && this.sameWindowAncestor(BlockingProgressMonitor.this.pane, BlockingProgressMonitor.this.noteLabel) && (noteLabelPoint = SwingUtilities.convertPoint(BlockingProgressMonitor.this.pane, p, BlockingProgressMonitor.this.noteLabel)) != null) {
                return at.getIndexAtPoint(noteLabelPoint);
            }
            return -1;
        }

        public Rectangle getCharacterBounds(int i) {
            Rectangle noteLabelRect;
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null && this.sameWindowAncestor(BlockingProgressMonitor.this.pane, BlockingProgressMonitor.this.noteLabel) && (noteLabelRect = at.getCharacterBounds(i)) != null) {
                return SwingUtilities.convertRectangle(BlockingProgressMonitor.this.noteLabel, noteLabelRect, BlockingProgressMonitor.this.pane);
            }
            return null;
        }

        private boolean sameWindowAncestor(Component src, Component dest) {
            if (src == null || dest == null) {
                return false;
            }
            return SwingUtilities.getWindowAncestor(src) == SwingUtilities.getWindowAncestor(dest);
        }

        public int getCharCount() {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getCharCount();
            }
            return -1;
        }

        public int getCaretPosition() {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getCaretPosition();
            }
            return -1;
        }

        public String getAtIndex(int part, int index) {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getAtIndex(part, index);
            }
            return null;
        }

        public String getAfterIndex(int part, int index) {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getAfterIndex(part, index);
            }
            return null;
        }

        public String getBeforeIndex(int part, int index) {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getBeforeIndex(part, index);
            }
            return null;
        }

        public AttributeSet getCharacterAttribute(int i) {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getCharacterAttribute(i);
            }
            return null;
        }

        public int getSelectionStart() {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getSelectionStart();
            }
            return -1;
        }

        public int getSelectionEnd() {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getSelectionEnd();
            }
            return -1;
        }

        public String getSelectedText() {
            AccessibleText at = this.getNoteLabelAccessibleText();
            if (at != null) {
                return at.getSelectedText();
            }
            return null;
        }
    }

    private class ProgressOptionPane
    extends JOptionPane {
        ProgressOptionPane(Object messageList) {
            super(messageList, 1, -1, null, BlockingProgressMonitor.this.cancelOption, null);
        }

        public int getMaxCharactersPerLineCount() {
            return 60;
        }

        public JDialog createDialog(Component parentComponent, String title) {
            Window window = SwingUtilities.getWindowAncestor(parentComponent);
            final JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, title, false) : new JDialog((Dialog)window, title, false);
            Container contentPane = dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this, "Center");
            dialog.pack();
            dialog.setLocationRelativeTo(parentComponent);
            dialog.addWindowListener(new WindowAdapter(){
                boolean gotFocus = false;

                public void windowClosing(WindowEvent we) {
                    ProgressOptionPane.this.setValue(BlockingProgressMonitor.this.cancelOption[0]);
                }

                public void windowActivated(WindowEvent we) {
                    if (!this.gotFocus) {
                        ProgressOptionPane.this.selectInitialValue();
                        this.gotFocus = true;
                    }
                }
            });
            this.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (dialog.isVisible() && event.getSource() == ProgressOptionPane.this && (event.getPropertyName().equals("value") || event.getPropertyName().equals("inputValue"))) {
                        dialog.setVisible(false);
                        dialog.dispose();
                    }
                }
            });
            return dialog;
        }

        public AccessibleContext getAccessibleContext() {
            return BlockingProgressMonitor.this.getAccessibleContext();
        }

        private AccessibleContext getAccessibleJOptionPane() {
            return super.getAccessibleContext();
        }
    }
}

