/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bbop.swing.ShapeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorUtil {
    protected static final Logger logger = Logger.getLogger(ColorUtil.class);
    public static final Map<String, Color> FANCY_HTML_COLOR_MAP = new LinkedHashMap<String, Color>();
    public static final Map<String, Color> HTML_COLOR_MAP = new LinkedHashMap<String, Color>();
    public static final Map<String, Color> JAVA_COLOR_MAP = new LinkedHashMap<String, Color>();

    private ColorUtil() {
    }

    public static String getName(Color color) {
        return ColorUtil.getName(color, HTML_COLOR_MAP);
    }

    public static String getFancyName(Color color) {
        return ColorUtil.getName(color, FANCY_HTML_COLOR_MAP);
    }

    public static String getJavaName(Color color) {
        return ColorUtil.getName(color, JAVA_COLOR_MAP);
    }

    public static String getName(Color color, Map<String, Color> colorMap) {
        String minName = null;
        double minDistance = Double.MAX_VALUE;
        double x = color.getRed();
        double y = color.getGreen();
        double z = color.getBlue();
        for (String name : colorMap.keySet()) {
            double c;
            double b;
            Color color2 = colorMap.get(name);
            double a = color2.getRed();
            double dist = ShapeUtil.distance(x, y, z, a, b = (double)color2.getGreen(), c = (double)color2.getBlue());
            if (!(dist < minDistance)) continue;
            minDistance = dist;
            minName = name;
        }
        return minName.toLowerCase();
    }

    public static Color mergeColors(Color ... colors) {
        int red = 0;
        int blue = 0;
        int green = 0;
        int alpha = 0;
        boolean first = true;
        for (Color c : colors) {
            red += c.getRed();
            blue += c.getBlue();
            green += c.getGreen();
            alpha += c.getAlpha();
        }
        return new Color(red / colors.length, green / colors.length, blue / colors.length, alpha / colors.length);
    }

    public static String getHTMLCode(Color color) {
        StringBuffer out = new StringBuffer();
        out.append(ColorUtil.getHexDigit(color.getRed() / 16));
        out.append(ColorUtil.getHexDigit(color.getRed() % 16));
        out.append(ColorUtil.getHexDigit(color.getGreen() / 16));
        out.append(ColorUtil.getHexDigit(color.getGreen() % 16));
        out.append(ColorUtil.getHexDigit(color.getBlue() / 16));
        out.append(ColorUtil.getHexDigit(color.getBlue() % 16));
        return out.toString();
    }

    public static Color getColor(String htmlCode) {
        int out = 0;
        if ((htmlCode = htmlCode.trim()).startsWith("#")) {
            htmlCode = htmlCode.substring(1, 7);
        }
        for (int i = 0; i < htmlCode.length(); ++i) {
            out = (int)((double)out + Math.pow(16.0, htmlCode.length() - i - 1) * (double)ColorUtil.getHexVal(htmlCode.charAt(i)));
        }
        return new Color(out);
    }

    protected static int getHexVal(char digit) {
        if (Character.isDigit(digit = Character.toUpperCase(digit))) {
            return digit - 48;
        }
        return 10 + (digit - 65);
    }

    protected static String getHexDigit(int val) {
        if (val < 10) {
            return val + "";
        }
        if (val == 10) {
            return "A";
        }
        if (val == 11) {
            return "B";
        }
        if (val == 12) {
            return "C";
        }
        if (val == 13) {
            return "D";
        }
        if (val == 14) {
            return "E";
        }
        if (val == 15) {
            return "F";
        }
        return null;
    }

    static {
        HTML_COLOR_MAP.put("black", ColorUtil.getColor("#000000"));
        HTML_COLOR_MAP.put("silver", ColorUtil.getColor("#C0C0C0"));
        HTML_COLOR_MAP.put("gray", ColorUtil.getColor("#808080"));
        HTML_COLOR_MAP.put("white", ColorUtil.getColor("#FFFFFF"));
        HTML_COLOR_MAP.put("maroon", ColorUtil.getColor("#800000"));
        HTML_COLOR_MAP.put("red", ColorUtil.getColor("#FF0000"));
        HTML_COLOR_MAP.put("purple", ColorUtil.getColor("#800080"));
        HTML_COLOR_MAP.put("fuchsia", ColorUtil.getColor("#FF00FF"));
        HTML_COLOR_MAP.put("green", ColorUtil.getColor("#008000"));
        HTML_COLOR_MAP.put("lime", ColorUtil.getColor("#00FF00"));
        HTML_COLOR_MAP.put("olive", ColorUtil.getColor("#808000"));
        HTML_COLOR_MAP.put("yellow", ColorUtil.getColor("#FFFF00"));
        HTML_COLOR_MAP.put("navy", ColorUtil.getColor("#000080"));
        HTML_COLOR_MAP.put("blue", ColorUtil.getColor("#0000FF"));
        HTML_COLOR_MAP.put("teal", ColorUtil.getColor("#008080"));
        HTML_COLOR_MAP.put("aqua", ColorUtil.getColor("#00FFFF"));
        FANCY_HTML_COLOR_MAP.put("Alice Blue", ColorUtil.getColor("#F0F8FF"));
        FANCY_HTML_COLOR_MAP.put("Antique White", ColorUtil.getColor("#FAEBD7"));
        FANCY_HTML_COLOR_MAP.put("Aqua", ColorUtil.getColor("#00FFFF"));
        FANCY_HTML_COLOR_MAP.put("Aquamarine", ColorUtil.getColor("#7FFFD4"));
        FANCY_HTML_COLOR_MAP.put("Azure", ColorUtil.getColor("#F0FFFF"));
        FANCY_HTML_COLOR_MAP.put("Beige", ColorUtil.getColor("#F5F5DC"));
        FANCY_HTML_COLOR_MAP.put("Bisque", ColorUtil.getColor("#FFE4C4"));
        FANCY_HTML_COLOR_MAP.put("Black", ColorUtil.getColor("#000000"));
        FANCY_HTML_COLOR_MAP.put("Blanched Almond", ColorUtil.getColor("#FFEBCD"));
        FANCY_HTML_COLOR_MAP.put("Blue", ColorUtil.getColor("#0000FF"));
        FANCY_HTML_COLOR_MAP.put("BlueViolet", ColorUtil.getColor("#8A2BE2"));
        FANCY_HTML_COLOR_MAP.put("Brown", ColorUtil.getColor("#A52A2A"));
        FANCY_HTML_COLOR_MAP.put("Burly Wood", ColorUtil.getColor("#DEB887"));
        FANCY_HTML_COLOR_MAP.put("Cadet Blue", ColorUtil.getColor("#5F9EA0"));
        FANCY_HTML_COLOR_MAP.put("Chartreuse", ColorUtil.getColor("#7FFF00"));
        FANCY_HTML_COLOR_MAP.put("Chocolate", ColorUtil.getColor("#D2691E"));
        FANCY_HTML_COLOR_MAP.put("Coral", ColorUtil.getColor("#FF7F50"));
        FANCY_HTML_COLOR_MAP.put("Cornflower Blue", ColorUtil.getColor("#6495ED"));
        FANCY_HTML_COLOR_MAP.put("Cornsilk", ColorUtil.getColor("#FFF8DC"));
        FANCY_HTML_COLOR_MAP.put("Crimson", ColorUtil.getColor("#DC143C"));
        FANCY_HTML_COLOR_MAP.put("Cyan", ColorUtil.getColor("#00FFFF"));
        FANCY_HTML_COLOR_MAP.put("Dark Blue", ColorUtil.getColor("#00008B"));
        FANCY_HTML_COLOR_MAP.put("Dark Cyan", ColorUtil.getColor("#008B8B"));
        FANCY_HTML_COLOR_MAP.put("Dark GoldenRod", ColorUtil.getColor("#B8860B"));
        FANCY_HTML_COLOR_MAP.put("Dark Gray", ColorUtil.getColor("#A9A9A9"));
        FANCY_HTML_COLOR_MAP.put("Dark Green", ColorUtil.getColor("#006400"));
        FANCY_HTML_COLOR_MAP.put("Dark Khaki", ColorUtil.getColor("#BDB76B"));
        FANCY_HTML_COLOR_MAP.put("Dark Magenta", ColorUtil.getColor("#8B008B"));
        FANCY_HTML_COLOR_MAP.put("Dark Olive Green", ColorUtil.getColor("#556B2F"));
        FANCY_HTML_COLOR_MAP.put("Dark orange", ColorUtil.getColor("#FF8C00"));
        FANCY_HTML_COLOR_MAP.put("Dark Orchid", ColorUtil.getColor("#9932CC"));
        FANCY_HTML_COLOR_MAP.put("Dark Red", ColorUtil.getColor("#8B0000"));
        FANCY_HTML_COLOR_MAP.put("Dark Salmon", ColorUtil.getColor("#E9967A"));
        FANCY_HTML_COLOR_MAP.put("Dark Sea Green", ColorUtil.getColor("#8FBC8F"));
        FANCY_HTML_COLOR_MAP.put("Dark Slate Blue", ColorUtil.getColor("#483D8B"));
        FANCY_HTML_COLOR_MAP.put("Dark Slate Gray", ColorUtil.getColor("#2F4F4F"));
        FANCY_HTML_COLOR_MAP.put("Dark Turquoise", ColorUtil.getColor("#00CED1"));
        FANCY_HTML_COLOR_MAP.put("Dark Violet", ColorUtil.getColor("#9400D3"));
        FANCY_HTML_COLOR_MAP.put("Deep Pink", ColorUtil.getColor("#FF1493"));
        FANCY_HTML_COLOR_MAP.put("Deep Sky Blue", ColorUtil.getColor("#00BFFF"));
        FANCY_HTML_COLOR_MAP.put("Dim Gray", ColorUtil.getColor("#696969"));
        FANCY_HTML_COLOR_MAP.put("Dodger Blue", ColorUtil.getColor("#1E90FF"));
        FANCY_HTML_COLOR_MAP.put("Fire Brick", ColorUtil.getColor("#B22222"));
        FANCY_HTML_COLOR_MAP.put("Floral White", ColorUtil.getColor("#FFFAF0"));
        FANCY_HTML_COLOR_MAP.put("Forest Green", ColorUtil.getColor("#228B22"));
        FANCY_HTML_COLOR_MAP.put("Fuchsia", ColorUtil.getColor("#FF00FF"));
        FANCY_HTML_COLOR_MAP.put("Gainsboro", ColorUtil.getColor("#DCDCDC"));
        FANCY_HTML_COLOR_MAP.put("Ghost White", ColorUtil.getColor("#F8F8FF"));
        FANCY_HTML_COLOR_MAP.put("Gold", ColorUtil.getColor("#FFD700"));
        FANCY_HTML_COLOR_MAP.put("GoldenRod", ColorUtil.getColor("#DAA520"));
        FANCY_HTML_COLOR_MAP.put("Gray", ColorUtil.getColor("#808080"));
        FANCY_HTML_COLOR_MAP.put("Grey", ColorUtil.getColor("#808080"));
        FANCY_HTML_COLOR_MAP.put("Green", ColorUtil.getColor("#008000"));
        FANCY_HTML_COLOR_MAP.put("Green Yellow", ColorUtil.getColor("#ADFF2F"));
        FANCY_HTML_COLOR_MAP.put("Honey Dew", ColorUtil.getColor("#F0FFF0"));
        FANCY_HTML_COLOR_MAP.put("Hot Pink", ColorUtil.getColor("#FF69B4"));
        FANCY_HTML_COLOR_MAP.put("Indian Red", ColorUtil.getColor("#CD5C5C"));
        FANCY_HTML_COLOR_MAP.put("Indigo", ColorUtil.getColor("#4B0082"));
        FANCY_HTML_COLOR_MAP.put("Ivory", ColorUtil.getColor("#FFFFF0"));
        FANCY_HTML_COLOR_MAP.put("Khaki", ColorUtil.getColor("#F0E68C"));
        FANCY_HTML_COLOR_MAP.put("Lavender", ColorUtil.getColor("#E6E6FA"));
        FANCY_HTML_COLOR_MAP.put("Lavender Blush", ColorUtil.getColor("#FFF0F5"));
        FANCY_HTML_COLOR_MAP.put("Lawn Green", ColorUtil.getColor("#7CFC00"));
        FANCY_HTML_COLOR_MAP.put("Lemon Chiffon", ColorUtil.getColor("#FFFACD"));
        FANCY_HTML_COLOR_MAP.put("Light Blue", ColorUtil.getColor("#ADD8E6"));
        FANCY_HTML_COLOR_MAP.put("Light Coral", ColorUtil.getColor("#F08080"));
        FANCY_HTML_COLOR_MAP.put("Light Cyan", ColorUtil.getColor("#E0FFFF"));
        FANCY_HTML_COLOR_MAP.put("Light GoldenRod Yellow", ColorUtil.getColor("#FAFAD2"));
        FANCY_HTML_COLOR_MAP.put("Light Gray", ColorUtil.getColor("#D3D3D3"));
        FANCY_HTML_COLOR_MAP.put("Light Grey", ColorUtil.getColor("#D3D3D3"));
        FANCY_HTML_COLOR_MAP.put("Light Green", ColorUtil.getColor("#90EE90"));
        FANCY_HTML_COLOR_MAP.put("Light Pink", ColorUtil.getColor("#FFB6C1"));
        FANCY_HTML_COLOR_MAP.put("Light Salmon", ColorUtil.getColor("#FFA07A"));
        FANCY_HTML_COLOR_MAP.put("Light Sea Green", ColorUtil.getColor("#20B2AA"));
        FANCY_HTML_COLOR_MAP.put("Light Sky Blue", ColorUtil.getColor("#87CEFA"));
        FANCY_HTML_COLOR_MAP.put("Light Slate Gray", ColorUtil.getColor("#778899"));
        FANCY_HTML_COLOR_MAP.put("Light Slate Grey", ColorUtil.getColor("#778899"));
        FANCY_HTML_COLOR_MAP.put("Light Steel Blue", ColorUtil.getColor("#B0C4DE"));
        FANCY_HTML_COLOR_MAP.put("Light Yellow", ColorUtil.getColor("#FFFFE0"));
        FANCY_HTML_COLOR_MAP.put("Lime", ColorUtil.getColor("#00FF00"));
        FANCY_HTML_COLOR_MAP.put("Lime Green", ColorUtil.getColor("#32CD32"));
        FANCY_HTML_COLOR_MAP.put("Linen", ColorUtil.getColor("#FAF0E6"));
        FANCY_HTML_COLOR_MAP.put("Magenta", ColorUtil.getColor("#FF00FF"));
        FANCY_HTML_COLOR_MAP.put("Maroon", ColorUtil.getColor("#800000"));
        FANCY_HTML_COLOR_MAP.put("Medium Aqua Marine", ColorUtil.getColor("#66CDAA"));
        FANCY_HTML_COLOR_MAP.put("Medium Blue", ColorUtil.getColor("#0000CD"));
        FANCY_HTML_COLOR_MAP.put("Medium Orchid", ColorUtil.getColor("#BA55D3"));
        FANCY_HTML_COLOR_MAP.put("Medium Purple", ColorUtil.getColor("#9370D8"));
        FANCY_HTML_COLOR_MAP.put("Medium Sea Green", ColorUtil.getColor("#3CB371"));
        FANCY_HTML_COLOR_MAP.put("Medium Slate Blue", ColorUtil.getColor("#7B68EE"));
        FANCY_HTML_COLOR_MAP.put("Medium Spring Green", ColorUtil.getColor("#00FA9A"));
        FANCY_HTML_COLOR_MAP.put("Medium Turquoise", ColorUtil.getColor("#48D1CC"));
        FANCY_HTML_COLOR_MAP.put("Medium Violet Red", ColorUtil.getColor("#C71585"));
        FANCY_HTML_COLOR_MAP.put("Midnight Blue", ColorUtil.getColor("#191970"));
        FANCY_HTML_COLOR_MAP.put("Mint Cream", ColorUtil.getColor("#F5FFFA"));
        FANCY_HTML_COLOR_MAP.put("Misty Rose", ColorUtil.getColor("#FFE4E1"));
        FANCY_HTML_COLOR_MAP.put("Moccasin", ColorUtil.getColor("#FFE4B5"));
        FANCY_HTML_COLOR_MAP.put("Navajo White", ColorUtil.getColor("#FFDEAD"));
        FANCY_HTML_COLOR_MAP.put("Navy", ColorUtil.getColor("#000080"));
        FANCY_HTML_COLOR_MAP.put("Old Lace", ColorUtil.getColor("#FDF5E6"));
        FANCY_HTML_COLOR_MAP.put("Olive", ColorUtil.getColor("#808000"));
        FANCY_HTML_COLOR_MAP.put("Olive Drab", ColorUtil.getColor("#6B8E23"));
        FANCY_HTML_COLOR_MAP.put("Orange", ColorUtil.getColor("#FFA500"));
        FANCY_HTML_COLOR_MAP.put("Orange Red", ColorUtil.getColor("#FF4500"));
        FANCY_HTML_COLOR_MAP.put("Orchid", ColorUtil.getColor("#DA70D6"));
        FANCY_HTML_COLOR_MAP.put("Pale Golden Rod", ColorUtil.getColor("#EEE8AA"));
        FANCY_HTML_COLOR_MAP.put("Pale Green", ColorUtil.getColor("#98FB98"));
        FANCY_HTML_COLOR_MAP.put("Pale Turquoise", ColorUtil.getColor("#AFEEEE"));
        FANCY_HTML_COLOR_MAP.put("Pale Violet Red", ColorUtil.getColor("#D87093"));
        FANCY_HTML_COLOR_MAP.put("Papaya Whip", ColorUtil.getColor("#FFEFD5"));
        FANCY_HTML_COLOR_MAP.put("Peach Puff", ColorUtil.getColor("#FFDAB9"));
        FANCY_HTML_COLOR_MAP.put("Peru", ColorUtil.getColor("#CD853F"));
        FANCY_HTML_COLOR_MAP.put("Pink", ColorUtil.getColor("#FFC0CB"));
        FANCY_HTML_COLOR_MAP.put("Plum", ColorUtil.getColor("#DDA0DD"));
        FANCY_HTML_COLOR_MAP.put("Powder Blue", ColorUtil.getColor("#B0E0E6"));
        FANCY_HTML_COLOR_MAP.put("Purple", ColorUtil.getColor("#800080"));
        FANCY_HTML_COLOR_MAP.put("Red", ColorUtil.getColor("#FF0000"));
        FANCY_HTML_COLOR_MAP.put("Rosy Brown", ColorUtil.getColor("#BC8F8F"));
        FANCY_HTML_COLOR_MAP.put("Royal Blue", ColorUtil.getColor("#4169E1"));
        FANCY_HTML_COLOR_MAP.put("Saddle Brown", ColorUtil.getColor("#8B4513"));
        FANCY_HTML_COLOR_MAP.put("Salmon", ColorUtil.getColor("#FA8072"));
        FANCY_HTML_COLOR_MAP.put("Sandy Brown", ColorUtil.getColor("#F4A460"));
        FANCY_HTML_COLOR_MAP.put("Sea Green", ColorUtil.getColor("#2E8B57"));
        FANCY_HTML_COLOR_MAP.put("Sea Shell", ColorUtil.getColor("#FFF5EE"));
        FANCY_HTML_COLOR_MAP.put("Sienna", ColorUtil.getColor("#A0522D"));
        FANCY_HTML_COLOR_MAP.put("Silver", ColorUtil.getColor("#C0C0C0"));
        FANCY_HTML_COLOR_MAP.put("Sky Blue", ColorUtil.getColor("#87CEEB"));
        FANCY_HTML_COLOR_MAP.put("Slate Blue", ColorUtil.getColor("#6A5ACD"));
        FANCY_HTML_COLOR_MAP.put("Slate Gray", ColorUtil.getColor("#708090"));
        FANCY_HTML_COLOR_MAP.put("Snow", ColorUtil.getColor("#FFFAFA"));
        FANCY_HTML_COLOR_MAP.put("Spring Green", ColorUtil.getColor("#00FF7F"));
        FANCY_HTML_COLOR_MAP.put("Steel Blue", ColorUtil.getColor("#4682B4"));
        FANCY_HTML_COLOR_MAP.put("Tan", ColorUtil.getColor("#D2B48C"));
        FANCY_HTML_COLOR_MAP.put("Teal", ColorUtil.getColor("#008080"));
        FANCY_HTML_COLOR_MAP.put("Thistle", ColorUtil.getColor("#D8BFD8"));
        FANCY_HTML_COLOR_MAP.put("Tomato", ColorUtil.getColor("#FF6347"));
        FANCY_HTML_COLOR_MAP.put("Turquoise", ColorUtil.getColor("#40E0D0"));
        FANCY_HTML_COLOR_MAP.put("Violet", ColorUtil.getColor("#EE82EE"));
        FANCY_HTML_COLOR_MAP.put("Wheat", ColorUtil.getColor("#F5DEB3"));
        FANCY_HTML_COLOR_MAP.put("White", ColorUtil.getColor("#FFFFFF"));
        FANCY_HTML_COLOR_MAP.put("White Smoke", ColorUtil.getColor("#F5F5F5"));
        FANCY_HTML_COLOR_MAP.put("Yellow", ColorUtil.getColor("#FFFF00"));
        FANCY_HTML_COLOR_MAP.put("Yellow Green", ColorUtil.getColor("#9ACD32"));
        JAVA_COLOR_MAP.put("black", Color.black);
        JAVA_COLOR_MAP.put("blue", Color.blue);
        JAVA_COLOR_MAP.put("cyan", Color.cyan);
        JAVA_COLOR_MAP.put("darkGray", Color.darkGray);
        JAVA_COLOR_MAP.put("gray", Color.gray);
        JAVA_COLOR_MAP.put("green", Color.green);
        JAVA_COLOR_MAP.put("lightGray", Color.lightGray);
        JAVA_COLOR_MAP.put("magenta", Color.magenta);
        JAVA_COLOR_MAP.put("orange", Color.orange);
        JAVA_COLOR_MAP.put("pink", Color.pink);
        JAVA_COLOR_MAP.put("red", Color.red);
        JAVA_COLOR_MAP.put("white", Color.white);
        JAVA_COLOR_MAP.put("yellow", Color.yellow);
    }
}

