/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Component;
import java.awt.PopupMenu;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.apache.log4j.Logger;

public class EnhancedMenuBar
extends JMenuBar {
    protected static final Logger logger = Logger.getLogger(EnhancedMenuBar.class);
    protected JMenu helpMenu;
    protected Component spacer = Box.createHorizontalGlue();

    public void setHelpMenu(JMenu menu) {
        this.helpMenu = menu;
        this.rearrange();
    }

    public JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            for (int i = 0; i < this.getMenuCount(); ++i) {
                JMenu menu = this.getMenu(i);
                if (menu == null || menu.getText() == null || !menu.getText().equalsIgnoreCase("help")) continue;
                this.helpMenu = menu;
                break;
            }
        }
        return this.helpMenu;
    }

    public Component add(Component comp) {
        Component out = super.add(comp);
        this.rearrange();
        return out;
    }

    protected void rearrange() {
        this.remove(this.spacer);
        if (this.getHelpMenu() != null) {
            this.remove(this.getHelpMenu());
        }
        super.add(this.spacer);
        if (this.getHelpMenu() != null) {
            super.add(this.getHelpMenu());
        }
    }

    public Component add(Component comp, int index) {
        Component out = super.add(comp, index);
        this.rearrange();
        return out;
    }

    public void add(Component comp, Object constraints) {
        super.add(comp, constraints);
        this.rearrange();
    }

    public void add(Component comp, Object constraints, int index) {
        super.add(comp, constraints, index);
        this.rearrange();
    }

    public JMenu add(JMenu c) {
        JMenu out = super.add(c);
        this.rearrange();
        return out;
    }

    public synchronized void add(PopupMenu popup) {
        super.add(popup);
        this.rearrange();
    }

    public Component add(String name, Component comp) {
        Component out = super.add(name, comp);
        this.rearrange();
        return out;
    }
}

