/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;
import org.apache.log4j.Logger;

public class FastTranslatedGraphics
extends Graphics {
    protected static final Logger logger = Logger.getLogger(FastTranslatedGraphics.class);
    protected Graphics g;
    int tx;
    int ty;

    public FastTranslatedGraphics(Graphics g) {
        this.g = g;
        this.tx = 0;
        this.ty = 0;
    }

    public void translateAbsolute(int x, int y) {
        this.tx = x;
        this.ty = y;
    }

    public void translate(int x, int y) {
        this.g.translate(x, y);
    }

    public void clearRect(int x, int y, int width, int height) {
        this.g.clearRect(x + this.tx, y + this.ty, width, height);
    }

    public void clipRect(int x, int y, int width, int height) {
        this.g.clipRect(x + this.tx, y + this.ty, width, height);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.g.copyArea(x + this.tx, y + this.ty, width, height, dx, dy);
    }

    public Graphics create() {
        return this.g.create();
    }

    public Graphics create(int x, int y, int width, int height) {
        return this.g.create(x + this.tx, y + this.ty, width, height);
    }

    public void dispose() {
        this.g.dispose();
    }

    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.g.draw3DRect(x + this.tx, y + this.ty, width, height, raised);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g.drawArc(x + this.tx, y + this.ty, width, height, startAngle, arcAngle);
    }

    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this.g.drawBytes(data, offset, length, x + this.tx, y + this.ty);
    }

    public void drawChars(char[] data, int offset, int length, int x, int y) {
        this.g.drawChars(data, offset, length, x + this.tx, y + this.ty);
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.g.drawImage(img, x + this.tx, y + this.ty, bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.g.drawImage(img, x + this.tx, y + this.ty, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.g.drawImage(img, x + this.tx, y + this.ty, width, height, bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.g.drawImage(img, x + this.tx, y + this.ty, width, height, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.g.drawImage(img, dx1 + this.tx, dy1 + this.ty, dx2 + this.tx, dy2 + this.ty, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.g.drawImage(img, dx1 + this.tx, dy1 + this.ty, dx2 + this.tx, dy2 + this.ty, sx1, sy1, sx2, sy2, observer);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.g.drawLine(x1 + this.tx, y1 + this.ty, x2 + this.tx, y2 + this.ty);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.g.drawOval(x + this.tx, y + this.ty, width, height);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
    }

    public void drawPolygon(Polygon p) {
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
    }

    public void drawRect(int x, int y, int width, int height) {
        this.g.drawRect(x + this.tx, y + this.ty, width, height);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g.drawRoundRect(x + this.tx, y + this.ty, width, height, arcWidth, arcHeight);
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
    }

    public void drawString(String str, int x, int y) {
        this.g.drawString(str, x + this.tx, y + this.ty);
    }

    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.g.fill3DRect(x + this.tx, y + this.ty, width, height, raised);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g.fillArc(x + this.tx, y + this.ty, width, height, startAngle, arcAngle);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.g.fillOval(x + this.tx, y + this.ty, width, height);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
    }

    public void fillPolygon(Polygon p) {
    }

    public void fillRect(int x, int y, int width, int height) {
        this.g.fillRect(x + this.tx, y + this.ty, width, height);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g.fillRoundRect(x + this.tx, y + this.ty, width, height, arcWidth, arcHeight);
    }

    public void finalize() {
        this.g.finalize();
        super.finalize();
    }

    public Shape getClip() {
        return this.g.getClip();
    }

    public Rectangle getClipBounds() {
        return this.g.getClipBounds();
    }

    public Rectangle getClipBounds(Rectangle r) {
        Rectangle clipRect = this.g.getClipBounds();
        r.x = clipRect.x;
        r.y = clipRect.y;
        r.width = clipRect.width;
        r.height = clipRect.height;
        return r;
    }

    public Rectangle getClipRect() {
        return this.g.getClipBounds();
    }

    public Color getColor() {
        return this.g.getColor();
    }

    public Font getFont() {
        return this.g.getFont();
    }

    public FontMetrics getFontMetrics() {
        return this.g.getFontMetrics();
    }

    public FontMetrics getFontMetrics(Font f) {
        return this.g.getFontMetrics(f);
    }

    public boolean hitClip(int x, int y, int width, int height) {
        return new Rectangle(x, y, width, height).intersects(this.g.getClipBounds());
    }

    public void setClip(int x, int y, int width, int height) {
        this.g.setClip(x + this.tx, y + this.ty, width, height);
    }

    public void setClip(Shape clip) {
    }

    public void setColor(Color c) {
        this.g.setColor(c);
    }

    public void setFont(Font f) {
        this.g.setFont(f);
    }

    public void setPaintMode() {
        this.g.setPaintMode();
    }

    public void setXORMode(Color c1) {
        this.g.setXORMode(c1);
    }

    public String toString() {
        return this.g.toString() + " [wrapped tranlation " + this.tx + ", " + this.ty + "]";
    }
}

