/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.bbop.swing.FocusHierarchyListener;
import org.bbop.util.MultiHashMap;
import org.bbop.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FocusHierarchyManager {
    protected static final Logger logger = Logger.getLogger(FocusHierarchyManager.class);
    protected static boolean enabled = false;
    protected static MultiMap<Component, FocusHierarchyListener> listeners;
    protected static PropertyChangeListener listener;

    protected static Collection<Component> getAncestors(Component oldValue) {
        HashSet<Component> out = new HashSet<Component>();
        while (oldValue != null) {
            if (listeners.containsKey(oldValue)) {
                out.add(oldValue);
            }
            oldValue = oldValue.getParent();
        }
        return out;
    }

    protected static void dispatchFocusChange(Component oldValue, Component newValue) {
        Collection<Component> previouslyFocused = FocusHierarchyManager.getAncestors(oldValue);
        Collection<Component> newlyFocused = FocusHierarchyManager.getAncestors(newValue);
        for (Component c : previouslyFocused) {
            if (newlyFocused.contains(c)) continue;
            FocusHierarchyManager.fireFocusedLost(c);
        }
        for (Component c : newlyFocused) {
            if (previouslyFocused.contains(c)) continue;
            FocusHierarchyManager.fireFocusedGained(c);
        }
    }

    protected static void fireFocusedLost(Component c) {
        for (FocusHierarchyListener listener : new LinkedList((Collection)listeners.get(c))) {
            listener.focusLost(new FocusEvent(c, 1005));
        }
    }

    protected static void fireFocusedGained(Component c) {
        for (FocusHierarchyListener listener : new LinkedList((Collection)listeners.get(c))) {
            listener.focusGained(new FocusEvent(c, 1004));
        }
    }

    public static void install() {
        listeners = new MultiHashMap<Component, FocusHierarchyListener>();
        enabled = true;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", listener);
    }

    protected static void ensureInstalled() {
        if (!enabled) {
            FocusHierarchyManager.install();
        }
    }

    public static void addFocusHierarchyListener(Component c, FocusHierarchyListener listener) {
        FocusHierarchyManager.ensureInstalled();
        listeners.add(c, listener);
    }

    public static void removeFocusHierarchyListener(Component c, FocusHierarchyListener listener) {
        FocusHierarchyManager.ensureInstalled();
        listeners.remove(c, listener);
    }

    public static Collection<FocusHierarchyListener> getFocusHierarchyListeners(Component c) {
        FocusHierarchyManager.ensureInstalled();
        return (Collection)listeners.get(c);
    }

    public static void uninstall() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", listener);
        enabled = false;
        listeners = null;
    }

    static {
        listener = new PropertyChangeListener(){
            protected PropertyChangeEvent lastEvent = null;

            public void propertyChange(PropertyChangeEvent evt) {
                if (this.lastEvent == null) {
                    this.lastEvent = evt;
                } else {
                    PropertyChangeEvent localLast = this.lastEvent;
                    this.lastEvent = null;
                    FocusHierarchyManager.dispatchFocusChange((Component)localLast.getOldValue(), (Component)evt.getNewValue());
                }
            }
        };
    }
}

