/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.log4j.Logger;
import org.bbop.swing.DragImageGenerator;
import org.bbop.swing.GhostedDragImage;

public class GhostImageController
implements DragSourceListener,
DragSourceMotionListener {
    protected static final Logger logger = Logger.getLogger(GhostImageController.class);
    protected GhostedDragImage ghost;
    protected static GhostImageController instance;
    protected static List<DragImageGenerator> generators;
    protected DragSourceDragEvent lastEvent;

    public static GhostImageController getInstance() {
        if (instance == null) {
            instance = new GhostImageController();
        }
        return instance;
    }

    public static void enable() {
        DragSource.getDefaultDragSource().addDragSourceListener(GhostImageController.getInstance());
        DragSource.getDefaultDragSource().addDragSourceMotionListener(GhostImageController.getInstance());
    }

    public static void disable() {
        DragSource.getDefaultDragSource().removeDragSourceListener(GhostImageController.getInstance());
        DragSource.getDefaultDragSource().removeDragSourceMotionListener(GhostImageController.getInstance());
    }

    public static void addImageGenerator(DragImageGenerator generator) {
        generators.add(generator);
    }

    public static void removeImageGenerator(DragImageGenerator generator) {
        generators.remove(generator);
    }

    protected void check(DragSourceDragEvent e) {
        this.lastEvent = e;
        Component src = e.getDragSourceContext().getComponent();
        if (this.ghost == null && src instanceof JComponent && src.isVisible()) {
            JComponent c = (JComponent)src;
            Point screen = e.getLocation();
            Point origin = c.getLocationOnScreen();
            Point imageOffset = new Point(0, 0);
            Icon icon = null;
            boolean opaque = false;
            if (c instanceof DragImageGenerator) {
                icon = ((DragImageGenerator)((Object)c)).getImage(e);
            }
            if (icon == null) {
                DragImageGenerator gen;
                Iterator<DragImageGenerator> i$ = generators.iterator();
                while (i$.hasNext() && (icon = (gen = i$.next()).getImage(e)) == null) {
                }
            }
            if (icon != null) {
                this.ghost = new GhostedDragImage(c, e.getLocation(), icon, imageOffset);
                if (opaque) {
                    this.ghost.setAlpha(1.0f);
                }
            }
        }
    }

    public void forceImageUpdate() {
        if (this.lastEvent != null && this.ghost != null) {
            this.ghost.dispose();
            this.ghost = null;
            this.check(this.lastEvent);
        }
    }

    public void dragEnter(DragSourceDragEvent e) {
        this.check(e);
        if (this.ghost != null) {
            this.ghost.move(e.getLocation());
        }
    }

    public void dragOver(DragSourceDragEvent e) {
        this.check(e);
        if (this.ghost != null) {
            this.ghost.move(e.getLocation());
        }
    }

    public void dropActionChanged(DragSourceDragEvent e) {
        this.check(e);
        if (this.ghost != null) {
            this.ghost.move(e.getLocation());
        }
    }

    public void dragDropEnd(DragSourceDropEvent e) {
        if (this.ghost != null) {
            if (e.getDropSuccess()) {
                this.ghost.dispose();
            } else {
                this.ghost.returnToOrigin();
            }
            this.ghost = null;
        }
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragMouseMoved(DragSourceDragEvent e) {
        this.check(e);
        if (this.ghost != null) {
            this.ghost.move(e.getLocation());
        }
    }

    static {
        generators = new LinkedList<DragImageGenerator>();
    }
}

