/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.bbop.swing.ComponentCellRenderer;
import org.bbop.swing.TextAreaTableCellRenderer;
import org.bbop.swing.multiheighttable.MultiheightTableUI;

public class MultiheightTable
extends JTable {
    protected static final Logger logger = Logger.getLogger(MultiheightTable.class);
    private static final long serialVersionUID = 1147784799846275231L;
    protected HashMap rowHeights = new HashMap();

    public MultiheightTable() {
        this(null, null, null);
    }

    public MultiheightTable(TableModel dm) {
        this(dm, null, null);
    }

    public MultiheightTable(TableModel dm, TableColumnModel cm) {
        this(dm, cm, null);
    }

    public MultiheightTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.setUI(new MultiheightTableUI());
    }

    public MultiheightTable(int numRows, int numColumns) {
        this(new DefaultTableModel(numRows, numColumns));
    }

    public MultiheightTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.setUI(new MultiheightTableUI());
    }

    public MultiheightTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.setUI(new MultiheightTableUI());
    }

    public int rowAtPoint(Point point) {
        int y = point.y;
        if (y < 0) {
            return -1;
        }
        int rowSpacing = this.getIntercellSpacing().height;
        int rowCount = this.getRowCount();
        int rowHeight = 0;
        for (int i = 0; i < rowCount; ++i) {
            if (y >= (rowHeight += this.getRowHeight(i) + rowSpacing)) continue;
            return i;
        }
        return -1;
    }

    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        int index = 0;
        int columnMargin = this.getColumnModel().getColumnMargin();
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        Rectangle cellFrame = new Rectangle();
        cellFrame.height = this.getRowHeight(row) + this.rowMargin;
        int rowSpacing = this.getIntercellSpacing().height;
        int y = 0;
        for (int i = 0; i < row; ++i) {
            y += this.getRowHeight(i) + rowSpacing;
        }
        cellFrame.y = y;
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            cellFrame.width = aColumn.getWidth() + columnMargin;
            if (index == column) break;
            cellFrame.x += cellFrame.width;
            ++index;
        }
        if (!includeSpacing) {
            Dimension spacing = this.getIntercellSpacing();
            cellFrame.setBounds(cellFrame.x + spacing.width / 2, cellFrame.y + spacing.height / 2, cellFrame.width - spacing.width, cellFrame.height - spacing.height);
        }
        return cellFrame;
    }

    public void tableChanged(TableModelEvent e) {
        Rectangle dirtyRegion;
        if (e == null || e.getFirstRow() == -1) {
            this.clearSelection();
            if (this.getAutoCreateColumnsFromModel()) {
                this.createDefaultColumnsFromModel();
            }
            this.resizeAndRepaint();
            if (this.tableHeader != null) {
                this.tableHeader.resizeAndRepaint();
            }
            return;
        }
        if (e.getType() == 1) {
            this.tableRowsInserted(e);
            return;
        }
        if (e.getType() == -1) {
            this.tableRowsDeleted(e);
            return;
        }
        int modelColumn = e.getColumn();
        int start = e.getFirstRow();
        int end = e.getLastRow();
        if (start == -1) {
            start = 0;
            end = Integer.MAX_VALUE;
        }
        if (modelColumn == -1) {
            dirtyRegion = new Rectangle(0, this.getCellRect((int)start, (int)0, (boolean)false).y, this.getColumnModel().getTotalColumnWidth(), 0);
        } else {
            int column = this.convertColumnIndexToView(modelColumn);
            dirtyRegion = this.getCellRect(start, column, false);
        }
        if (end != Integer.MAX_VALUE) {
            dirtyRegion.height = this.getCellRect((int)(end + 1), (int)0, (boolean)false).y - dirtyRegion.y;
            this.repaint(dirtyRegion.x, dirtyRegion.y, dirtyRegion.width, dirtyRegion.height);
        } else {
            this.resizeAndRepaint();
        }
    }

    private void tableRowsInserted(TableModelEvent e) {
        int start = e.getFirstRow();
        int end = e.getLastRow();
        if (start < 0) {
            start = 0;
        }
        int rowCount = this.getRowCount();
        int rowsInserted = end - start + 1;
        for (int r = start; r < rowCount; ++r) {
            Integer height = (Integer)this.rowHeights.get(new Integer(r));
            if (height == null) continue;
            this.rowHeights.put(new Integer(r + rowsInserted), height);
        }
        Rectangle drawRect = new Rectangle(0, this.getCellRect((int)start, (int)0, (boolean)false).y, this.getColumnModel().getTotalColumnWidth(), 0);
        drawRect.height = this.getCellRect((int)rowCount, (int)0, (boolean)false).y - drawRect.y;
        if (this.selectionModel != null) {
            if (end < 0) {
                end = this.getRowCount() - 1;
            }
            int length = end - start + 1;
            this.selectionModel.insertIndexInterval(start, length, true);
        }
        this.revalidate();
    }

    private void tableRowsDeleted(TableModelEvent e) {
        int start = e.getFirstRow();
        int end = e.getLastRow();
        if (start < 0) {
            start = 0;
        }
        int deletedCount = end - start + 1;
        int previousRowCount = this.getRowCount() + deletedCount;
        for (int i = start; i <= end; ++i) {
            this.resetRowHeight(i);
        }
        for (int r = end + 1; r < previousRowCount; ++r) {
            Integer height = (Integer)this.rowHeights.get(new Integer(r));
            if (height == null) continue;
            this.rowHeights.put(new Integer(r - deletedCount), height);
        }
        Rectangle drawRect = new Rectangle(0, this.getCellRect((int)start, (int)0, (boolean)false).y, this.getColumnModel().getTotalColumnWidth(), 0);
        drawRect.height = this.getCellRect((int)previousRowCount, (int)0, (boolean)false).y - drawRect.y;
        if (this.selectionModel != null) {
            if (end < 0) {
                end = this.getRowCount() - 1;
            }
            this.selectionModel.removeIndexInterval(start, end);
        }
        this.revalidate();
    }

    public int getRowHeight(int row) {
        Object o = this.rowHeights.get(new Integer(row));
        if (o == null) {
            return this.getRowHeight(false);
        }
        return (Integer)o;
    }

    public int getRowHeight() {
        double rows;
        double totalHeight = 0.0;
        for (rows = 0.0; rows < (double)this.dataModel.getRowCount(); rows += 1.0) {
            totalHeight += (double)this.getRowHeight((int)rows);
        }
        return (int)Math.ceil(totalHeight / rows);
    }

    public int getRowHeight(boolean getAverage) {
        if (getAverage) {
            return this.getRowHeight();
        }
        return super.getRowHeight();
    }

    public void setRowHeight(int row, int height) {
        this.rowHeights.put(new Integer(row), new Integer(height));
        this.revalidate();
    }

    public void resetRowHeight(int row) {
        this.rowHeights.remove(new Integer(row));
        this.revalidate();
    }

    public void resetRowHeight() {
        this.rowHeights.clear();
        this.revalidate();
    }

    protected int getPreferredRowHeight(int row) {
        int maxSize = this.getRowHeight(false);
        for (int j = 0; j < this.dataModel.getColumnCount(); ++j) {
            Component c = this.prepareRenderer(this.getCellRenderer(row, j), row, j);
            int preferredHeight = (int)c.getPreferredSize().getHeight();
            if (preferredHeight <= maxSize) continue;
            maxSize = preferredHeight;
        }
        return maxSize;
    }

    public void autosizeRows() {
        for (int i = 0; i < this.dataModel.getRowCount(); ++i) {
            this.setRowHeight(i, this.getPreferredRowHeight(i));
        }
    }

    public static void main(String[] args) throws Exception {
        JPanel thing = new JPanel();
        thing.add(new JButton("Hi"));
        thing.add(new JLabel("there"));
        Vector<Object> rows = new Vector<Object>();
        Vector<String> rowA = new Vector<String>();
        Vector<String> rowB = new Vector<String>();
        Vector<Object> rowC = new Vector<Object>();
        rowA.addElement("Twas brillig\nand the slithy toves\ndid gyre and gimble\nin the wabe");
        rowA.addElement("I once knew a man from Nantucket");
        rowB.addElement("Hey baby");
        rowB.addElement("Got a quarter?");
        rowC.addElement("Eat beets");
        rowC.addElement(thing);
        rows.addElement(rowA);
        rows.addElement(rowB);
        rows.addElement(rowC);
        rows.addElement(rowA.clone());
        rows.addElement(rowB.clone());
        rows.addElement(rowC.clone());
        rows.addElement(rowA.clone());
        rows.addElement(rowB.clone());
        rows.addElement(rowA.clone());
        rows.addElement(rowB.clone());
        rows.addElement(rowC.clone());
        rows.addElement(rowA.clone());
        rows.addElement(rowB.clone());
        rows.addElement(rowA.clone());
        rows.addElement(rowB.clone());
        rows.addElement(rowC.clone());
        rows.addElement(rowA.clone());
        rows.addElement(rowB.clone());
        Vector<String> rowNames = new Vector<String>();
        rowNames.addElement("left");
        rowNames.addElement("right");
        MultiheightTable table = new MultiheightTable(new DefaultTableModel(rows, rowNames));
        table.setDefaultRenderer(Class.forName("java.awt.Component"), new ComponentCellRenderer());
        table.setDefaultRenderer(Class.forName("java.lang.Object"), new TextAreaTableCellRenderer());
        table.setCellEditor(null);
        table.setCellSelectionEnabled(false);
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(false);
        table.autosizeRows();
        JOptionPane.showMessageDialog(null, new JScrollPane(table));
    }
}

