/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.log4j.Logger;
import org.bbop.swing.AbstractIconView;
import org.bbop.swing.IconFactory;
import org.bbop.util.ObjectUtil;

public class PluggableImageHTMLEditorKit
extends HTMLEditorKit {
    protected static final Logger logger = Logger.getLogger(PluggableImageHTMLEditorKit.class);
    protected Map<String, IconFactory> iconFactoryMap = new HashMap<String, IconFactory>();

    public void installFactory(String suffix, IconFactory factory) {
        this.iconFactoryMap.put(suffix, factory);
    }

    public void uninstallFactory(String suffix, IconFactory factory) {
        if (ObjectUtil.equals(this.iconFactoryMap.get(suffix), factory)) {
            this.iconFactoryMap.remove(suffix);
        }
    }

    public ViewFactory getViewFactory() {
        return new PluggableImageHTMLFactory();
    }

    public static URL getImageURL(Element elem) {
        String src = (String)elem.getAttributes().getAttribute(HTML.Attribute.SRC);
        if (src == null) {
            return null;
        }
        URL reference = ((HTMLDocument)elem.getDocument()).getBase();
        try {
            URL u = new URL(reference, src);
            return u;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected class PluggableImageHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        protected PluggableImageHTMLFactory() {
        }

        public View create(Element elem) {
            String suffix;
            IconFactory factory;
            String url;
            int index;
            HTML.Tag kind;
            Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (o instanceof HTML.Tag && (kind = (HTML.Tag)o) == HTML.Tag.IMG && (index = (url = PluggableImageHTMLEditorKit.getImageURL(elem).toString()).lastIndexOf(46)) > 0 && (factory = PluggableImageHTMLEditorKit.this.iconFactoryMap.get(suffix = url.substring(index + 1, url.length()))) != null) {
                return new AbstractIconView(elem){

                    public Icon createIcon(URL url, int width, int height) {
                        return factory.createIcon(url, width, height);
                    }
                };
            }
            return super.create(elem);
        }
    }
}

