/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.bbop.swing.ImageUtils;
import org.bbop.swing.MapColorsFilter;

public class RecolorableImageIcon
implements Icon {
    protected static final Logger logger = Logger.getLogger(RecolorableImageIcon.class);
    protected Color color;
    protected Color replaceColor;
    protected Image originalImage;
    protected ImageIcon imageIcon;

    public RecolorableImageIcon(ImageIcon icon, Color replaceColor, Color withColor) {
        this(icon.getImage(), replaceColor, withColor);
    }

    public RecolorableImageIcon(Image image, Color replaceColor, Color withColor) {
        this.originalImage = image;
        this.replaceColor = replaceColor;
        this.setColor(withColor);
    }

    public void setColor(Color color) {
        MapColorsFilter filter = new MapColorsFilter(this.replaceColor.getRGB(), color.getRGB());
        new ImageIcon(this.originalImage);
        BufferedImage filtered = filter.filter(ImageUtils.convertImageToARGB(this.originalImage), null);
        this.imageIcon = new ImageIcon(filtered);
        this.color = color;
    }

    public int getIconHeight() {
        return this.imageIcon.getIconHeight();
    }

    public int getIconWidth() {
        return this.imageIcon.getIconWidth();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.imageIcon.paintIcon(c, g, x, y);
    }
}

