/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.apache.log4j.Logger;

public class RootView
extends View {
    protected static final Logger logger = Logger.getLogger(RootView.class);
    protected EditorKit editorKit;
    protected JComponent container;
    private View view;

    public RootView(JComponent c, EditorKit editorKit) {
        super(null);
        this.setContainer(c);
        this.editorKit = editorKit;
    }

    public void setContainer(JComponent container) {
        if (container == null) {
            container = new JPanel();
        }
        this.container = container;
    }

    public void setView(View v) {
        View oldView = this.view;
        this.view = null;
        if (oldView != null) {
            oldView.setParent(null);
        }
        if (v != null) {
            v.setParent(this);
        }
        this.view = v;
    }

    public AttributeSet getAttributes() {
        return null;
    }

    public float getPreferredSpan(int axis) {
        if (this.view != null) {
            return this.view.getPreferredSpan(axis);
        }
        return 10.0f;
    }

    public float getMinimumSpan(int axis) {
        if (this.view != null) {
            return this.view.getMinimumSpan(axis);
        }
        return 10.0f;
    }

    public float getMaximumSpan(int axis) {
        return 2.1474836E9f;
    }

    public void preferenceChanged(View child, boolean width, boolean height) {
        if (this.container != null) {
            this.container.revalidate();
        }
    }

    public float getAlignment(int axis) {
        if (this.view != null) {
            return this.view.getAlignment(axis);
        }
        return 0.0f;
    }

    public void paint(Graphics g, Shape allocation) {
        if (this.view != null) {
            Rectangle alloc = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
            this.setSize(alloc.width, alloc.height);
            this.view.paint(g, allocation);
        }
    }

    public void setParent(View parent) {
        throw new Error("Can't set parent on root view");
    }

    public int getViewCount() {
        return 1;
    }

    public View getView(int n) {
        return this.view;
    }

    public int getViewIndex(int pos, Position.Bias b) {
        return 0;
    }

    public Shape getChildAllocation(int index, Shape a) {
        return a;
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        if (this.view != null) {
            return this.view.modelToView(pos, a, b);
        }
        return null;
    }

    public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
        if (this.view != null) {
            return this.view.modelToView(p0, b0, p1, b1, a);
        }
        return null;
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
        if (this.view != null) {
            int retValue = this.view.viewToModel(x, y, a, bias);
            return retValue;
        }
        return -1;
    }

    public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        if (this.view != null) {
            int nextPos = this.view.getNextVisualPositionFrom(pos, b, a, direction, biasRet);
            if (nextPos != -1) {
                pos = nextPos;
            } else {
                biasRet[0] = b;
            }
        }
        return pos;
    }

    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        if (this.view != null) {
            this.view.insertUpdate(e, a, f);
        }
    }

    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        if (this.view != null) {
            this.view.removeUpdate(e, a, f);
        }
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        if (this.view != null) {
            this.view.changedUpdate(e, a, f);
        }
    }

    public Document getDocument() {
        if (this.view != null) {
            return this.view.getDocument();
        }
        return null;
    }

    public int getStartOffset() {
        if (this.view != null) {
            return this.view.getStartOffset();
        }
        return this.getElement().getStartOffset();
    }

    public int getEndOffset() {
        if (this.view != null) {
            return this.view.getEndOffset();
        }
        return this.getElement().getEndOffset();
    }

    public Element getElement() {
        if (this.view != null) {
            return this.view.getElement();
        }
        return this.getDocument().getDefaultRootElement();
    }

    public View breakView(int axis, float len, Shape a) {
        throw new Error("Can't break root view");
    }

    public int getResizeWeight(int axis) {
        if (this.view != null) {
            return this.view.getResizeWeight(axis);
        }
        return 0;
    }

    public void setSize(float width, float height) {
        if (this.view != null) {
            this.view.setSize(width, height);
        }
    }

    public Container getContainer() {
        return this.container;
    }

    public ViewFactory getViewFactory() {
        return this.editorKit.getViewFactory();
    }
}

