/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class ScaledIcon
implements Icon {
    protected static final Logger logger = Logger.getLogger(ScaledIcon.class);
    protected int width = -1;
    protected int height = -1;
    protected double widthScaleFactor = 1.0;
    protected double heightScaleFactor = 1.0;
    protected Icon icon;
    protected boolean antialias;

    public ScaledIcon(Icon icon, int width, int height) {
        this.icon = icon;
        this.setDimension(width, height);
    }

    public ScaledIcon(Icon icon, int dim) {
        this.icon = icon;
        this.setDimension(dim);
    }

    public ScaledIcon(Icon icon) {
        this.setIcon(icon);
    }

    public void setAntialias(boolean antialias) {
        this.antialias = antialias;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        if (icon == null) {
            this.setDimension(0, 0);
        } else {
            this.setDimension(icon.getIconWidth(), icon.getIconHeight());
        }
    }

    public void setDimension(int dimension) {
        int width = -1;
        int height = -1;
        if (this.icon != null) {
            if (this.icon.getIconWidth() < this.icon.getIconHeight()) {
                height = dimension;
            } else {
                width = dimension;
            }
        }
        this.setDimension(width, height);
    }

    public void setDimension(int width, int height) {
        if (this.icon == null) {
            this.widthScaleFactor = 0.0;
            this.heightScaleFactor = 0.0;
            this.width = 0;
            this.height = 0;
            return;
        }
        this.widthScaleFactor = 1.0;
        this.heightScaleFactor = 1.0;
        if (height > 0) {
            this.heightScaleFactor = (double)height / (double)this.icon.getIconHeight();
        }
        if (width > 0) {
            this.widthScaleFactor = (double)width / (double)this.icon.getIconWidth();
        }
        if (width == -1) {
            this.widthScaleFactor = this.heightScaleFactor;
        }
        if (height == -1) {
            this.heightScaleFactor = this.widthScaleFactor;
        }
        width = (int)((double)this.icon.getIconWidth() * this.widthScaleFactor);
        height = (int)((double)this.icon.getIconHeight() * this.heightScaleFactor);
        this.width = width;
        this.height = height;
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.icon == null) {
            return;
        }
        if (this.widthScaleFactor == 1.0 && this.heightScaleFactor == 1.0) {
            this.icon.paintIcon(c, g, x, y);
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.antialias) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2.translate(x, y);
        g2.scale(this.widthScaleFactor, this.heightScaleFactor);
        this.icon.paintIcon(c, g, 0, 0);
        g2.scale(1.0 / this.widthScaleFactor, 1.0 / this.heightScaleFactor);
        g2.translate(-x, -y);
    }
}

