/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Component;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ScalingComponent
extends JComponent {
    protected static final Logger logger = Logger.getLogger(ScalingComponent.class);
    protected JComponent scaleMe;
    protected boolean preserveAspect = true;
    protected CellRendererPane pane = new CellRendererPane();

    public ScalingComponent() {
        this.setLayout(null);
        this.enableEvents(995327L);
    }

    public ScalingComponent(JComponent scaleMe) {
        this();
        this.add(this.pane);
        this.setScaledComponent(scaleMe);
    }

    public void setScaledComponent(JComponent scaleMe) {
        this.scaleMe = scaleMe;
        scaleMe.setSize(this.getPreferredSize());
        this.pane.add(scaleMe);
    }

    protected void processMouseEvent(MouseEvent e) {
        int x = this.translateX(e.getX());
        int y = this.translateY(e.getY());
        this.scaleMe.setSize(this.scaleMe.getPreferredSize());
        this.scaleMe.validate();
        Component c = SwingUtilities.getDeepestComponentAt(this.scaleMe, x, y);
        if (c != null) {
            Point p = SwingUtilities.convertPoint(this.scaleMe, x, y, c);
            e = new MouseEvent(c, e.getID(), e.getWhen(), e.getModifiers(), p.x, p.x, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            c.dispatchEvent(e);
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        int x = this.translateX(e.getX());
        int y = this.translateY(e.getY());
        this.scaleMe.setSize(this.scaleMe.getPreferredSize());
        this.scaleMe.validate();
        Component c = SwingUtilities.getDeepestComponentAt(this.scaleMe, x, y);
        if (c != null) {
            Point p = SwingUtilities.convertPoint(this.scaleMe, x, y, c);
            e = new MouseEvent(c, e.getID(), e.getWhen(), e.getModifiers(), p.x, p.x, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            c.dispatchEvent(e);
        }
    }

    public boolean handleEvent(Event evt) {
        return super.handleEvent(evt);
    }

    protected double internalGetXScale() {
        return (double)this.getWidth() / this.scaleMe.getPreferredSize().getWidth();
    }

    protected double internalGetYScale() {
        return (double)this.getHeight() / this.scaleMe.getPreferredSize().getHeight();
    }

    protected double getXScale() {
        if (this.preserveAspect) {
            return Math.min(this.internalGetXScale(), this.internalGetYScale());
        }
        return this.internalGetXScale();
    }

    protected double getYScale() {
        if (this.preserveAspect) {
            return Math.min(this.internalGetXScale(), this.internalGetYScale());
        }
        return this.internalGetYScale();
    }

    protected int translateX(double x) {
        double xoffset = ((double)this.getWidth() - this.scaleMe.getPreferredSize().getWidth() * this.getXScale()) / 2.0;
        return (int)((x - xoffset) / this.getXScale());
    }

    protected int translateY(double y) {
        double yoffset = ((double)this.getHeight() - this.scaleMe.getPreferredSize().getHeight() * this.getYScale()) / 2.0;
        return (int)((y - yoffset) / this.getYScale());
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        int xoffset = 0;
        int yoffset = 0;
        double xscale = this.internalGetXScale();
        double yscale = this.internalGetYScale();
        if (this.preserveAspect) {
            if (xscale < yscale) {
                height = (int)(this.scaleMe.getPreferredSize().getHeight() * xscale);
                yoffset = (this.getHeight() - height) / 2;
            } else {
                width = (int)(this.scaleMe.getPreferredSize().getWidth() * yscale);
                xoffset = (this.getWidth() - width) / 2;
            }
        }
        g2.translate(xoffset, yoffset);
        g2.scale(this.getXScale(), this.getYScale());
        this.pane.paintComponent(g, this.scaleMe, this, 0, 0, (int)this.scaleMe.getPreferredSize().getWidth(), (int)this.scaleMe.getPreferredSize().getHeight(), true);
    }
}

