/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Shape;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import org.apache.log4j.Logger;
import org.bbop.swing.PathOpList;
import org.bbop.swing.ShapeExtender;
import org.bbop.swing.ShapeUtil;
import org.bbop.util.StringUtil;

public class ShapeMorpher {
    protected static final Logger logger = Logger.getLogger(ShapeMorpher.class);
    protected Shape source;
    protected Shape target;
    protected Shape massagedSource;
    protected Shape massagedTarget;
    protected float[] sp = new float[6];
    protected float[] tp = new float[6];
    protected Point2D.Float lastPoint = new Point2D.Float(0.0f, 0.0f);

    private static void printSideBySide(PathIterator a, String labela, PathIterator b, String labelb, int padAmt) {
        PathOpList sourceList = new PathOpList(a, false);
        PathOpList targetList = new PathOpList(b, false);
        int[] sendpointIndices = sourceList.getSubpathIndices(false);
        int[] tendpointIndices = targetList.getSubpathIndices(false);
        logger.info((Object)(StringUtil.pad(labela, ' ', padAmt) + "| " + StringUtil.pad(labelb, ' ', padAmt)));
        logger.info((Object)(StringUtil.pad("", '-', padAmt) + "+-" + StringUtil.pad("", '-', padAmt)));
        for (int i = 0; i < sourceList.size() || i < targetList.size(); ++i) {
            boolean isSourceEndpoint = false;
            for (int index : sendpointIndices) {
                if (index != i) continue;
                isSourceEndpoint = true;
                break;
            }
            boolean isTargetEndpoint = false;
            for (int index : tendpointIndices) {
                if (index != i) continue;
                isTargetEndpoint = true;
                break;
            }
            String sourceString = "";
            if (sourceList.size() > i) {
                sourceString = sourceList.getSegment(i).toString();
            }
            String targetString = "";
            if (targetList.size() > i) {
                targetString = targetList.getSegment(i).toString();
            }
            logger.info((Object)(i + ")" + (isSourceEndpoint ? (char)'*' : ' ') + StringUtil.pad(sourceString, ' ', padAmt) + "|" + (isTargetEndpoint ? (char)'*' : ' ') + StringUtil.pad(targetString, ' ', padAmt)));
        }
    }

    public ShapeMorpher(Shape source, Shape target, double flatness, int limit, ShapeExtender extender) {
        this.source = source;
        this.target = target;
        int padAmt = 50;
        GeneralPath simplifiedSource = new GeneralPath();
        GeneralPath simplifiedTarget = new GeneralPath();
        simplifiedSource.append(new FlatteningPathIterator(source.getPathIterator(null), flatness, limit), false);
        simplifiedTarget.append(new FlatteningPathIterator(target.getPathIterator(null), flatness, limit), false);
        Shape[] shapes = extender.extend(simplifiedSource, simplifiedTarget);
        this.massagedSource = shapes[0];
        this.massagedTarget = shapes[1];
        PathIterator sourceIterator = this.massagedSource.getPathIterator(null);
        PathIterator targetIterator = this.massagedTarget.getPathIterator(null);
        this.lastPoint.setLocation(0.0f, 0.0f);
        int pos = 0;
        while (!sourceIterator.isDone()) {
            int stype = -111;
            int ttype = -111;
            int outtype = -111;
            try {
                stype = sourceIterator.currentSegment(this.sp);
                ttype = targetIterator.currentSegment(this.tp);
                outtype = this.matchCoords(stype, this.sp, ttype, this.tp);
                sourceIterator.next();
                targetIterator.next();
                if (targetIterator.isDone() != sourceIterator.isDone()) {
                    logger.info((Object)"Aha!");
                }
                ++pos;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public Shape getShapeAtTime(float time, GeneralPath out) {
        if (time == 0.0f) {
            return this.source;
        }
        if (time == 1.0f) {
            return this.target;
        }
        if (out == null) {
            out = new GeneralPath();
        } else {
            out.reset();
        }
        PathIterator sourceIterator = this.massagedSource.getPathIterator(null);
        PathIterator targetIterator = this.massagedTarget.getPathIterator(null);
        this.lastPoint.setLocation(0.0f, 0.0f);
        while (!sourceIterator.isDone()) {
            int stype = sourceIterator.currentSegment(this.sp);
            int ttype = targetIterator.currentSegment(this.tp);
            int outtype = this.matchCoords(stype, this.sp, ttype, this.tp);
            this.interpolateCoords(outtype, this.sp, this.tp, time);
            ShapeMorpher.addOp(out, outtype, this.sp, this.lastPoint);
            sourceIterator.next();
            targetIterator.next();
        }
        return out;
    }

    public static void addOp(GeneralPath out, int op, float[] sp2, Point2D.Float lastPoint) {
        if (op == 4) {
            out.closePath();
        } else if (op == 3) {
            out.curveTo(sp2[0], sp2[1], sp2[2], sp2[3], sp2[4], sp2[5]);
            lastPoint.x = sp2[4];
            lastPoint.y = sp2[5];
        } else if (op == 1) {
            out.lineTo(sp2[0], sp2[1]);
            lastPoint.x = sp2[0];
            lastPoint.y = sp2[1];
        } else if (op == 0) {
            out.moveTo(sp2[0], sp2[1]);
            lastPoint.x = sp2[0];
            lastPoint.y = sp2[1];
        } else if (op == 2) {
            out.quadTo(sp2[0], sp2[1], sp2[2], sp2[3]);
            lastPoint.x = sp2[2];
            lastPoint.y = sp2[3];
        } else {
            throw new IllegalArgumentException("bad path iterator segment type " + op);
        }
    }

    protected void interpolateCoords(int outtype, float[] sp2, float[] tp2, float time) {
        int count = ShapeUtil.getArrayUse(outtype);
        for (int i = 0; i < count; ++i) {
            sp2[i] = sp2[i] + (tp2[i] - sp2[i]) * time;
        }
    }

    protected int lineToCubic(float[] lessComplexCoords) {
        lessComplexCoords[4] = lessComplexCoords[0];
        lessComplexCoords[5] = lessComplexCoords[1];
        lessComplexCoords[2] = lessComplexCoords[0];
        lessComplexCoords[3] = lessComplexCoords[1];
        lessComplexCoords[0] = this.lastPoint.x;
        lessComplexCoords[1] = this.lastPoint.y;
        return 3;
    }

    protected int quadToCubic(float[] moreComplexCoords) {
        throw new UnsupportedOperationException("We don't yet support cubic to quad");
    }

    protected int quadToLine(double[] coords) {
        coords[0] = coords[2];
        coords[1] = coords[3];
        return 1;
    }

    protected int cubicToLine(double[] coords) {
        coords[0] = coords[4];
        coords[1] = coords[5];
        return 1;
    }

    protected boolean convertCurveToLine() {
        return false;
    }

    protected static boolean isMoreComplex(int op, int op2) {
        if (op == op2) {
            return false;
        }
        if (op == 3) {
            return true;
        }
        if (op == 2 && op2 == 1) {
            return true;
        }
        return op == 1 && op2 == 4;
    }

    protected int matchCoords(int stype, float[] sp2, int ttype, float[] tp2) {
        float[] lessComplexCoords;
        float[] moreComplexCoords;
        int lessComplexType;
        int moreComplexType;
        if (stype == ttype) {
            return stype;
        }
        if (ShapeMorpher.isMoreComplex(stype, ttype)) {
            moreComplexType = stype;
            lessComplexType = ttype;
            moreComplexCoords = sp2;
            lessComplexCoords = tp2;
        } else {
            moreComplexType = ttype;
            lessComplexType = stype;
            moreComplexCoords = tp2;
            lessComplexCoords = sp2;
        }
        if (lessComplexType == 2) {
            this.quadToCubic(lessComplexCoords);
            return 3;
        }
        if (lessComplexType == 1) {
            this.lineToCubic(lessComplexCoords);
            if (moreComplexType == 2) {
                this.quadToCubic(moreComplexCoords);
            }
            return 3;
        }
        if (lessComplexType == 4 && moreComplexType == 4) {
            return 4;
        }
        return -1;
    }
}

