/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing.dropbox;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.bbop.swing.SwingUtil;
import org.bbop.swing.dropbox.DropBoxContents;
import org.bbop.swing.dropbox.DropBoxContentsTransferable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropBoxPanel
extends JPanel {
    protected static final Logger logger = Logger.getLogger(DropBoxPanel.class);
    protected Component glue;
    protected Component dropGhost;
    protected int orientation;

    public DropBoxPanel() {
        this(1);
    }

    public DropBoxPanel(int orientation) {
        this.orientation = orientation;
        int ghostSize = 5;
        this.setLayout(new BoxLayout(this, orientation));
        this.dropGhost = new JPanel();
        if (orientation == 0) {
            this.glue = Box.createHorizontalGlue();
            this.dropGhost.setMinimumSize(new Dimension(ghostSize, 0));
            this.dropGhost.setPreferredSize(new Dimension(ghostSize, 0));
            this.dropGhost.setMaximumSize(new Dimension(ghostSize, Integer.MAX_VALUE));
        } else {
            this.glue = Box.createVerticalGlue();
            this.dropGhost.setMinimumSize(new Dimension(0, ghostSize));
            this.dropGhost.setPreferredSize(new Dimension(0, ghostSize));
            this.dropGhost.setMaximumSize(new Dimension(Integer.MAX_VALUE, ghostSize));
        }
        this.dropGhost.setBackground(Color.green);
        this.add(this.glue);
        this.setDropTarget(new DropTarget(this, new DropTargetListener(){
            protected int dropPos;

            public void dragEnter(DropTargetDragEvent dtde) {
            }

            public void dragExit(DropTargetEvent dte) {
                DropBoxPanel.this.remove(DropBoxPanel.this.dropGhost);
                SwingUtil.masterValidate(DropBoxPanel.this);
            }

            public void dragOver(DropTargetDragEvent dtde) {
                Point loc = dtde.getLocation();
                Component c = DropBoxPanel.this.getComponentAt(loc.x, loc.y);
                Component contents = (Component)((Object)this.getContents(dtde));
                if (SwingUtilities.isDescendingFrom(DropBoxPanel.this, contents)) {
                    dtde.rejectDrag();
                    return;
                }
                if (c != null && !c.equals(DropBoxPanel.this.dropGhost)) {
                    if (c != DropBoxPanel.this) {
                        int index;
                        Point reCalc = SwingUtilities.convertPoint(DropBoxPanel.this, loc, c);
                        boolean isLeft = reCalc.x <= c.getWidth() / 2;
                        boolean isTop = reCalc.y <= c.getHeight() / 2;
                        int oldGhostIndex = SwingUtil.getIndex(DropBoxPanel.this, DropBoxPanel.this.dropGhost);
                        if (oldGhostIndex != -1) {
                            DropBoxPanel.this.remove(DropBoxPanel.this.dropGhost);
                        }
                        if ((index = SwingUtil.getIndex(DropBoxPanel.this, c)) == -1) {
                            this.dropPos = -1;
                            dtde.rejectDrag();
                            return;
                        }
                        boolean before = DropBoxPanel.this.orientation == 1 ? isTop : isLeft;
                        this.dropPos = before ? index : index + 1;
                        DropBoxPanel.this.add(DropBoxPanel.this.dropGhost, this.dropPos);
                        SwingUtil.masterValidate(DropBoxPanel.this);
                        dtde.acceptDrag(3);
                    } else {
                        DropBoxPanel.this.remove(DropBoxPanel.this.dropGhost);
                    }
                }
            }

            public void drop(DropTargetDropEvent dtde) {
                logger.info((Object)("dropPos = " + this.dropPos));
                if (this.dropPos == -1) {
                    DropBoxPanel.this.remove(DropBoxPanel.this.dropGhost);
                    SwingUtil.masterValidate(DropBoxPanel.this);
                    dtde.rejectDrop();
                    return;
                }
                Transferable t = dtde.getTransferable();
                try {
                    Object o = t.getTransferData(DropBoxContentsTransferable.DROP_BOX_CONTENTS_FLAVOR);
                    if (o != null && o instanceof DropBoxContents) {
                        DropBoxPanel.this.remove(DropBoxPanel.this.dropGhost);
                        DropBoxContents c = (DropBoxContents)o;
                        int index = SwingUtil.getIndex(DropBoxPanel.this, (Component)((Object)c));
                        if (index >= 0 && index < this.dropPos) {
                            --this.dropPos;
                        }
                        if (index == this.dropPos) {
                            dtde.rejectDrop();
                        } else {
                            Container p = ((Component)((Object)c)).getParent();
                            logger.info((Object)("removing " + c + " from " + p));
                            SwingUtil.masterValidate((Component)((Object)c));
                            DropBoxPanel.this.add((Component)((Object)c), null, this.dropPos);
                            dtde.acceptDrop(3);
                        }
                    }
                    SwingUtil.masterValidate(DropBoxPanel.this);
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            protected DropBoxContents getContents(DropTargetDragEvent e) {
                Transferable t = e.getTransferable();
                try {
                    Object o = t.getTransferData(DropBoxContentsTransferable.DROP_BOX_CONTENTS_FLAVOR);
                    if (o != null && o instanceof DropBoxContents) {
                        return (DropBoxContents)o;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return null;
            }

            public void dropActionChanged(DropTargetDragEvent dtde) {
            }
        }));
    }

    public List<DropBoxContents> getContents() {
        LinkedList<DropBoxContents> contents = new LinkedList<DropBoxContents>();
        for (Component c : this.getComponents()) {
            if (c.equals(this.glue) || c.equals(this.dropGhost)) continue;
            contents.add((DropBoxContents)((Object)c));
        }
        return contents;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        this.remove(this.glue);
        if (index > this.getComponentCount()) {
            index = this.getComponentCount();
        }
        super.addImpl(comp, constraints, index);
        super.addImpl(this.glue, null, -1);
    }
}

