/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing.multiheighttable;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;
import org.bbop.swing.MultiheightTable;

public class MultiheightTableUI
extends BasicTableUI {
    protected static final Logger logger = Logger.getLogger(MultiheightTableUI.class);

    private Dimension createTableSize(long width) {
        int height = ((MultiheightTable)this.table).getCellRect((int)this.table.getRowCount(), (int)0, (boolean)false).y;
        int totalMarginWidth = this.table.getColumnModel().getColumnMargin() * this.table.getColumnCount();
        long widthWithMargin = Math.abs(width) + (long)totalMarginWidth;
        if (widthWithMargin > Integer.MAX_VALUE) {
            widthWithMargin = Integer.MAX_VALUE;
        }
        return new Dimension((int)widthWithMargin, height);
    }

    public Dimension getMinimumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMinWidth();
        }
        return this.createTableSize(width);
    }

    public Dimension getPreferredSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createTableSize(width);
    }

    public Dimension getMaximumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMaxWidth();
        }
        return this.createTableSize(width);
    }

    public void paint(Graphics g, JComponent c) {
        Rectangle oldClipBounds = g.getClipBounds();
        Rectangle clipBounds = new Rectangle(oldClipBounds);
        int tableWidth = this.table.getColumnModel().getTotalColumnWidth();
        clipBounds.width = Math.min(clipBounds.width, tableWidth);
        g.setClip(clipBounds);
        this.paintGrid(g);
        int firstIndex = this.table.rowAtPoint(new Point(0, clipBounds.y));
        int lastIndex = this.lastVisibleRow(clipBounds);
        Rectangle rowRect = new Rectangle(0, 0, tableWidth, ((MultiheightTable)this.table).getRowHeight(firstIndex) + this.table.getRowMargin());
        rowRect.y = this.table.getCellRect((int)firstIndex, (int)0, (boolean)false).y;
        for (int index = firstIndex; index <= lastIndex; ++index) {
            if (rowRect.intersects(clipBounds)) {
                this.paintRow(g, index);
            }
            rowRect.y += rowRect.height;
            rowRect.height = ((MultiheightTable)this.table).getRowHeight(index + 1);
        }
        g.setClip(oldClipBounds);
    }

    private void paintGrid(Graphics g) {
        g.setColor(this.table.getGridColor());
        if (this.table.getShowHorizontalLines()) {
            this.paintHorizontalLines(g);
        }
        if (this.table.getShowVerticalLines()) {
            this.paintVerticalLines(g);
        }
    }

    private void paintHorizontalLines(Graphics g) {
        Rectangle r;
        Rectangle rect = r = g.getClipBounds();
        int rowMargin = this.table.getRowMargin();
        int firstIndex = this.table.rowAtPoint(new Point(0, r.y));
        int lastIndex = this.lastVisibleRow(r);
        int y = this.table.getCellRect((int)(firstIndex + 1), (int)0, (boolean)false).y - 1;
        for (int index = firstIndex; index <= lastIndex; ++index) {
            if (y >= rect.y && y <= rect.y + rect.height) {
                g.drawLine(rect.x, y, rect.x + rect.width - 1, y);
            }
            y += ((MultiheightTable)this.table).getRowHeight(index + 1) + rowMargin;
        }
    }

    private void paintVerticalLines(Graphics g) {
        Rectangle rect = g.getClipBounds();
        int x = 0;
        int count = this.table.getColumnCount();
        int horizontalSpacing = this.table.getIntercellSpacing().width;
        for (int index = 0; index <= count; ++index) {
            if (x > 0 && x - 1 >= rect.x && x - 1 <= rect.x + rect.width) {
                g.drawLine(x - 1, rect.y, x - 1, rect.y + rect.height - 1);
            }
            if (index >= count) continue;
            x += this.table.getColumnModel().getColumn(index).getWidth() + horizontalSpacing;
        }
    }

    private void paintRow(Graphics g, int row) {
        Rectangle rect = g.getClipBounds();
        int column = 0;
        boolean drawn = false;
        int draggedColumnIndex = -1;
        Rectangle draggedCellRect = null;
        Dimension spacing = this.table.getIntercellSpacing();
        JTableHeader header = this.table.getTableHeader();
        Rectangle cellRect = new Rectangle();
        cellRect.height = ((MultiheightTable)this.table).getRowHeight(row) + spacing.height;
        cellRect.y = this.table.getCellRect((int)row, (int)0, (boolean)false).y;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            cellRect.width = aColumn.getWidth() + spacing.width;
            if (cellRect.intersects(rect)) {
                drawn = true;
                if (header == null || aColumn != header.getDraggedColumn()) {
                    this.paintCell(g, cellRect, row, column);
                } else {
                    g.setColor(this.table.getParent().getBackground());
                    g.fillRect(cellRect.x, cellRect.y, cellRect.width, cellRect.height);
                    draggedCellRect = new Rectangle(cellRect);
                    draggedColumnIndex = column;
                }
            } else if (drawn) break;
            cellRect.x += cellRect.width;
            ++column;
        }
        if (draggedColumnIndex != -1 && draggedCellRect != null) {
            draggedCellRect.x += header.getDraggedDistance();
            g.setColor(this.table.getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            g.setColor(this.table.getGridColor());
            int x1 = draggedCellRect.x;
            int y1 = draggedCellRect.y;
            int x2 = x1 + draggedCellRect.width - 1;
            int y2 = y1 + draggedCellRect.height - 1;
            if (this.table.getShowVerticalLines()) {
                g.drawLine(x2, y1, x2, y2);
            }
            if (this.table.getShowHorizontalLines()) {
                g.drawLine(x1, y2, x2, y2);
            }
            this.paintCell(g, draggedCellRect, row, draggedColumnIndex);
        }
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        int spacingHeight = this.table.getRowMargin();
        int spacingWidth = this.table.getColumnModel().getColumnMargin();
        cellRect.setBounds(cellRect.x + spacingWidth / 2, cellRect.y + spacingHeight / 2, cellRect.width - spacingWidth, cellRect.height - spacingHeight);
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            if (component.getParent() == null) {
                this.rendererPane.add(component);
            }
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
        cellRect.setBounds(cellRect.x - spacingWidth / 2, cellRect.y - spacingHeight / 2, cellRect.width + spacingWidth, cellRect.height + spacingHeight);
    }

    private int lastVisibleRow(Rectangle clip) {
        int lastIndex = this.table.rowAtPoint(new Point(0, clip.y + clip.height - 1));
        if (lastIndex == -1) {
            lastIndex = this.table.getRowCount() - 1;
        }
        return lastIndex;
    }
}

