/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.bbop.swing.DragFriendlyUI;

public class DragFriendlyTreeUI
extends BasicTreeUI
implements DragFriendlyUI {
    protected static final Logger logger = Logger.getLogger(DragFriendlyTreeUI.class);
    protected boolean disableEvents = false;
    protected boolean dragging = false;
    protected static int idgen = 0;
    protected int id = ++idgen;

    public String toString() {
        return "DragFriendlyTreeUI " + this.id;
    }

    public DragFriendlyTreeUI() {
        TreeIcon minusIcon = new TreeIcon(2);
        TreeIcon plusIcon = new TreeIcon(1);
        UIManager.put("Tree.expandedIcon", minusIcon);
        UIManager.put("Tree.collapsedIcon", plusIcon);
        this.setExpandedIcon(new TreeIcon(2));
        this.setCollapsedIcon(new TreeIcon(1));
        this.setRightChildIndent(minusIcon.getIconWidth() + 4);
    }

    protected void installDefaults() {
        super.installDefaults();
    }

    public void setRightChildIndent(int newAmount) {
        super.setRightChildIndent(newAmount);
    }

    protected void updateSize() {
        this.validCachedPreferredSize = false;
        if (this.tree != null) {
            this.tree.treeDidChange();
        }
    }

    protected int getRowX(int row, int depth) {
        return super.getRowX(row, depth);
    }

    public void setIsDragging(boolean dragging) {
        this.dragging = dragging;
    }

    protected MouseListener createMouseListener() {
        return new DragFriendlyMouseHandler();
    }

    public class DragFriendlyMouseHandler
    extends MouseAdapter {
        public void mouseReleased(MouseEvent e) {
            if (DragFriendlyTreeUI.this.dragging || e.isConsumed()) {
                return;
            }
            if (DragFriendlyTreeUI.this.tree != null && DragFriendlyTreeUI.this.tree.isEnabled()) {
                DragFriendlyTreeUI.this.tree.requestFocus();
                TreePath path = DragFriendlyTreeUI.this.getClosestPathForLocation(DragFriendlyTreeUI.this.tree, e.getX(), e.getY());
                if (path != null) {
                    int x;
                    Rectangle bounds = DragFriendlyTreeUI.this.getPathBounds(DragFriendlyTreeUI.this.tree, path);
                    if (e.getY() > bounds.y + bounds.height) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        DragFriendlyTreeUI.this.checkForClickInExpandControl(path, e.getX(), e.getY());
                    }
                    if ((x = e.getX()) > bounds.x && x <= bounds.x + bounds.width && !DragFriendlyTreeUI.this.startEditing(path, e)) {
                        DragFriendlyTreeUI.this.selectPathForEvent(path, e);
                    }
                }
            }
        }
    }

    public static class TreeIcon
    implements Icon {
        public static final int PLUS = 1;
        public static final int MINUS = 2;
        private static final int width = 8;
        private static final int height = 8;
        private int type;
        private Color foreground;
        private Color background;

        public TreeIcon(int type) {
            this(type, Color.black);
        }

        public TreeIcon(int type, Color foreground) {
            this.type = type;
            this.background = Color.white;
            this.foreground = foreground;
        }

        public int getIconHeight() {
            return 8;
        }

        public int getIconWidth() {
            return 8;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.white);
            g.fillRect(x, y, 8, 8);
            g.setColor(this.foreground);
            g.drawRect(x, y, 8, 8);
            g.drawLine(x + 2, y + 4, x + 6, y + 4);
            if (this.type == 1) {
                g.drawLine(x + 4, y + 2, x + 4, y + 6);
            }
        }
    }
}

