/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bbop.util.ArgumentSpec;
import org.bbop.util.CommandLineParseException;
import org.bbop.util.Tag;
import org.bbop.util.TagSpec;

public class CommandLineParser {
    protected static final Logger logger = Logger.getLogger(CommandLineParser.class);

    public static Tag parse(TagSpec spec, String[] arguments) throws CommandLineParseException {
        Vector<String> argList = new Vector<String>();
        for (int i = 0; i < arguments.length; ++i) {
            argList.add(arguments[i]);
        }
        return CommandLineParser.parse(spec, argList, false, false);
    }

    protected static Tag finalizeTag(TagSpec spec, Tag tag, boolean tentative) throws CommandLineParseException {
        if (tentative) {
            logger.info((Object)("finalized still-tentative " + tag));
            return null;
        }
        if (!tag.isImplied()) {
            for (Object defaultObj : spec.getDefaultValues()) {
                Iterator it2 = tag.getArguments().iterator();
                boolean foundDef = false;
                while (it2.hasNext()) {
                    Object o = it2.next();
                    if (o instanceof Tag && defaultObj instanceof Tag) {
                        Tag otag = (Tag)o;
                        Tag deftag = (Tag)defaultObj;
                        if (!otag.getName().equals(deftag.getName())) continue;
                        foundDef = true;
                        break;
                    }
                    if (!(o instanceof String) || !(defaultObj instanceof String)) continue;
                    foundDef = true;
                    break;
                }
                if (foundDef) continue;
                tag.getArguments().add(0, defaultObj);
            }
        }
        return tag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Tag parse(TagSpec spec, List arguments, boolean tentative, boolean takeLiterally) throws CommandLineParseException {
        ArgumentSpec as;
        Iterator it2;
        Tag tag = new Tag(spec.getName(), tentative);
        Object orphanTag = null;
        ArgumentSpec impliedSpec = spec.getImpliedSpec();
        ArgumentSpec untypedSpec = new ArgumentSpec(null, 0);
        Iterator it = spec.getArgumentSpecs().iterator();
        Vector<ArgumentSpec> argumentSpecs = new Vector<ArgumentSpec>();
        while (it.hasNext()) {
            ArgumentSpec as2 = (ArgumentSpec)it.next();
            if (as2.getTagSpec() == null) {
                untypedSpec = new ArgumentSpec(null, as2.getCardinality());
                continue;
            }
            argumentSpecs.add(as2);
        }
        if (tag.isImplied()) {
            block1: for (Object o : spec.getDefaultValues()) {
                tag.getArguments().add(o);
                if (o instanceof String) {
                    if (untypedSpec.getCardinality() <= 0) continue;
                    untypedSpec = new ArgumentSpec(null, untypedSpec.getCardinality() - 1);
                    continue;
                }
                if (!(o instanceof Tag)) continue;
                Tag otag = (Tag)o;
                it2 = argumentSpecs.iterator();
                int i = 0;
                while (it2.hasNext()) {
                    as = (ArgumentSpec)it2.next();
                    if (as.getTagSpec().getName().equals(otag.getName())) {
                        if (as.getCardinality() == 1) {
                            it2.remove();
                            continue block1;
                        }
                        if (as.getCardinality() <= 0) continue block1;
                        argumentSpecs.set(i, new ArgumentSpec(as.getTagSpec(), as.getCardinality() - 1));
                        continue block1;
                    }
                    ++i;
                }
            }
        }
        it = arguments.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            it.remove();
            if (takeLiterally || !s.startsWith("-")) {
                if (untypedSpec.getCardinality() > 0 || untypedSpec.getCardinality() < 0) {
                    tag.getArguments().add(s);
                    tentative = false;
                    if (untypedSpec.getCardinality() > 0) {
                        untypedSpec = new ArgumentSpec(null, untypedSpec.getCardinality() - 1);
                    }
                } else if (impliedSpec != null) {
                    arguments.add(0, s);
                    Tag childTag = CommandLineParser.parse(impliedSpec.getTagSpec(), arguments, true, takeLiterally);
                    it = arguments.iterator();
                    if (childTag == null) return CommandLineParser.finalizeTag(spec, tag, tentative);
                    tag.getArguments().add(childTag);
                    tentative = false;
                    if (impliedSpec.getCardinality() == 1) {
                        impliedSpec = null;
                    } else if (impliedSpec.getCardinality() > 0) {
                        impliedSpec = new ArgumentSpec(impliedSpec.getTagSpec(), impliedSpec.getCardinality() - 1);
                    }
                } else {
                    arguments.add(0, s);
                    return CommandLineParser.finalizeTag(spec, tag, tentative);
                }
                takeLiterally = false;
                continue;
            }
            if (s.equals("--")) {
                takeLiterally = true;
                continue;
            }
            orphanTag = null;
            boolean found = false;
            it2 = argumentSpecs.iterator();
            int i = 0;
            while (it2.hasNext()) {
                as = (ArgumentSpec)it2.next();
                if (as.getTagSpec().getName().equals(s)) {
                    found = true;
                    Tag childTag = CommandLineParser.parse(as.getTagSpec(), arguments, false, takeLiterally);
                    tag.getArguments().add(childTag);
                    tentative = false;
                    it = arguments.iterator();
                    if (as.getCardinality() == 1) {
                        it2.remove();
                        break;
                    }
                    if (as.getCardinality() <= 0) break;
                    argumentSpecs.set(i, new ArgumentSpec(as.getTagSpec(), as.getCardinality() - 1));
                    break;
                }
                ++i;
            }
            if (found) continue;
            arguments.add(0, s);
            it = arguments.iterator();
            if (impliedSpec == null) return CommandLineParser.finalizeTag(spec, tag, tentative);
            Tag childTag = CommandLineParser.parse(impliedSpec.getTagSpec(), arguments, true, takeLiterally);
            it = arguments.iterator();
            if (childTag == null) return CommandLineParser.finalizeTag(spec, tag, tentative);
            tentative = false;
            tag.getArguments().add(childTag);
            if (impliedSpec.getCardinality() == 1) {
                impliedSpec = null;
                continue;
            }
            if (impliedSpec.getCardinality() <= 0) continue;
            impliedSpec = new ArgumentSpec(impliedSpec.getTagSpec(), impliedSpec.getCardinality() - 1);
        }
        return CommandLineParser.finalizeTag(spec, tag, tentative);
    }
}

