/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.bbop.io.IOUtil;
import org.bbop.util.DefaultHasher;
import org.bbop.util.Hasher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskCachedSet<E>
extends AbstractSet<E>
implements Set<E> {
    protected static final Logger logger = Logger.getLogger(DiskCachedSet.class);
    protected int cacheSize = 0;
    protected File diskPath;
    protected Hasher hasher;
    protected Set memCache;
    protected Exception deathException;
    protected boolean assumeNoClashes = true;

    public DiskCachedSet() {
        this(null, null, false, 0);
    }

    public DiskCachedSet(File file, Hasher hasher, boolean assumeNoClashes, int cacheSize) {
        this.hasher = hasher == null ? DefaultHasher.getInstance() : hasher;
        if (file == null) {
            try {
                this.diskPath = IOUtil.createTempDir("diskcachedset", "");
            }
            catch (Exception ex) {
                this.die(ex);
            }
        } else {
            this.diskPath = file;
        }
        this.assumeNoClashes = assumeNoClashes;
        this.setCacheSize(cacheSize);
    }

    public void setCacheSize(int cacheSize2) {
    }

    protected void die(Exception ex) {
        if (this.deathException == null) {
            this.deathException = ex;
            this.setCacheSize(-1);
        }
    }

    protected Set createMemCache() {
        return new TreeSet();
    }

    protected File getPathForObject(E o) {
        return new File(this.diskPath, this.hasher.hashCode(o));
    }

    protected byte getClashPileSize(File file) throws IOException {
        if (!file.exists()) {
            return 0;
        }
        BufferedInputStream istream = new BufferedInputStream(new FileInputStream(file));
        byte out = (byte)((InputStream)istream).read();
        ((InputStream)istream).close();
        return out;
    }

    protected Collection<E> getClashPile(File file) throws IOException, ClassNotFoundException {
        Collection<Object> clashPile;
        if (!file.exists()) {
            clashPile = new LinkedList<Object>();
        } else {
            BufferedInputStream istream = new BufferedInputStream(new FileInputStream(file));
            if (this.assumeNoClashes) {
                clashPile = new LinkedList();
                ObjectInputStream oistream = new ObjectInputStream(istream);
                clashPile.add(oistream.readObject());
                oistream.close();
            } else {
                ((InputStream)istream).read();
                ObjectInputStream oistream = new ObjectInputStream(istream);
                clashPile = (Collection)oistream.readObject();
                oistream.close();
            }
            ((InputStream)istream).close();
        }
        return clashPile;
    }

    protected void writeClashPile(File file, Collection<E> clashPile) throws IOException {
        if (clashPile == null || clashPile.size() == 0) {
            file.delete();
        } else {
            if (clashPile.size() > 1) {
                logger.info((Object)("clashes found on keyfile " + file));
            }
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
            if (this.assumeNoClashes) {
                ObjectOutputStream ostream = new ObjectOutputStream(stream);
                ostream.writeObject(clashPile.iterator().next());
                ostream.close();
            } else {
                ((OutputStream)stream).write(clashPile.size());
                ObjectOutputStream ostream = new ObjectOutputStream(stream);
                ostream.writeObject(clashPile);
                ostream.close();
            }
            ((OutputStream)stream).close();
        }
    }

    protected void writeToDisk(E o) {
        File file = this.getPathForObject(o);
        try {
            Collection<E> clashPile = this.getClashPile(file);
            clashPile.add(o);
            this.writeClashPile(file, clashPile);
        }
        catch (Exception ex) {
            this.die(ex);
        }
    }

    protected E fetchFromDisk(E o) {
        File file = this.getPathForObject(o);
        try {
            Collection<E> clashPile = this.getClashPile(file);
            for (E item : clashPile) {
                if (!this.hasher.equals(item, o)) continue;
                return item;
            }
        }
        catch (Exception ex) {
            this.die(ex);
        }
        return null;
    }

    protected void deleteFromDisk(E o) {
        File file = this.getPathForObject(o);
        try {
            Collection<E> clashPile = this.getClashPile(file);
            Iterator<E> it = clashPile.iterator();
            while (it.hasNext()) {
                E item = it.next();
                if (!this.hasher.equals(item, o)) continue;
                it.remove();
            }
            this.writeClashPile(file, clashPile);
        }
        catch (Exception ex) {
            this.die(ex);
        }
    }

    @Override
    public boolean contains(Object o) {
        if (this.assumeNoClashes) {
            return this.getPathForObject(o).exists();
        }
        return this.fetchFromDisk(o) != null;
    }

    @Override
    public boolean add(E o) {
        if (this.contains(o)) {
            return false;
        }
        this.writeToDisk(o);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (!this.contains(o)) {
            return false;
        }
        this.deleteFromDisk(o);
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new DiskIterator(this.diskPath);
    }

    @Override
    public int size() {
        int out = 0;
        try {
            File[] files;
            for (File file : files = this.diskPath.listFiles()) {
                out += this.getClashPileSize(file);
            }
        }
        catch (Exception ex) {
            this.die(ex);
        }
        return out;
    }

    private static long addToSet(Set s, Object o) {
        long time = System.nanoTime();
        s.add(o);
        return System.nanoTime() - time;
    }

    private static long fetchFromSet(Set s, Object o) {
        long time = System.nanoTime();
        s.contains(o);
        return System.nanoTime() - time;
    }

    private static void dumpResults(String name, Collection<SetTest> c) {
        logger.info((Object)(name + ":"));
        for (SetTest st : c) {
            logger.info((Object)("   " + st.name + " = " + st.time));
            st.time = 0L;
        }
    }

    public static void main(String[] args) {
        String s2;
        int i;
        LinkedList<SetTest> testSets = new LinkedList<SetTest>();
        testSets.add(new SetTest("DiskCachedSet(checkclashes)", new DiskCachedSet()));
        testSets.add(new SetTest("DiskCachedSet(noclashes)", new DiskCachedSet(null, null, true, 0)));
        testSets.add(new SetTest("HashSet", new HashSet()));
        testSets.add(new SetTest("TreeSet", new TreeSet()));
        Random random = new Random();
        LinkedList<String> stringKeeper = new LinkedList<String>();
        for (i = 0; i < 10000; ++i) {
            s2 = random.nextInt() + "";
            for (SetTest st : testSets) {
                st.time += DiskCachedSet.addToSet(st.set, s2);
            }
            stringKeeper.add(s2);
        }
        DiskCachedSet.dumpResults("ADD", testSets);
        for (i = 0; i < 10000; ++i) {
            s2 = random.nextInt() + "";
            for (SetTest st : testSets) {
                st.time += DiskCachedSet.fetchFromSet(st.set, s2);
            }
        }
        DiskCachedSet.dumpResults("FETCH MISSES", testSets);
        for (String s2 : stringKeeper) {
            for (SetTest st : testSets) {
                st.time += DiskCachedSet.fetchFromSet(st.set, s2);
            }
        }
        DiskCachedSet.dumpResults("FETCH HITS", testSets);
    }

    private static class SetTest {
        public Set set;
        public long time = 0L;
        public String name;

        public SetTest(String name, Set set) {
            this.name = name;
            this.set = set;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DiskIterator
    implements Iterator<E> {
        protected File[] files;
        protected int currentIndex;
        protected Iterator<E> currentIterator;

        public DiskIterator(File diskPath) {
            this.files = diskPath.listFiles();
            this.currentIndex = 0;
            this.currentIterator = this.getCurrentCollection().iterator();
        }

        @Override
        public E next() {
            Object out = this.currentIterator.next();
            if (!this.currentIterator.hasNext()) {
                ++this.currentIndex;
                this.currentIterator = this.currentIndex >= this.files.length ? null : this.getCurrentCollection().iterator();
            }
            return out;
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator != null;
        }

        protected Collection<E> getCurrentCollection() {
            try {
                return DiskCachedSet.this.getClashPile(this.files[this.currentIndex]);
            }
            catch (Exception ex) {
                DiskCachedSet.this.die(ex);
                return Collections.emptySet();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

