/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.bbop.util.Superset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastSuperset<T>
extends AbstractCollection<T>
implements Superset<T> {
    protected static final Logger logger = Logger.getLogger(FastSuperset.class);
    protected List<Collection<? extends T>> subsets = new LinkedList<Collection<? extends T>>();
    protected Collection<T> modifyMe;

    @Override
    public Iterator<T> iterator() {
        return new SupersetIterator();
    }

    @Override
    public boolean add(T o) {
        if (this.modifyMe == null) {
            throw new UnsupportedOperationException("This superset is immutable");
        }
        if (!this.contains(o)) {
            return this.modifyMe.add(o);
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.modifyMe == null) {
            throw new UnsupportedOperationException("This superset is immutable");
        }
        return this.modifyMe.remove(o);
    }

    @Override
    public boolean isEmpty() {
        for (Collection<T> s : this.subsets) {
            if (s.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        if (this.modifyMe == null || this.subsets.size() != 1) {
            throw new UnsupportedOperationException("This superset contains unmodifiable subsets, and cannot be cleared");
        }
        this.modifyMe.clear();
    }

    @Override
    public boolean contains(Object o) {
        for (Collection<T> s : this.subsets) {
            if (!s.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addSubset(Collection<? extends T> set, boolean modifiable) {
        if (modifiable) {
            this.modifyMe = set;
        }
        this.subsets.add(set);
    }

    @Override
    public void addSubset(Collection<? extends T> set) {
        this.addSubset(set, false);
    }

    @Override
    public boolean removeSubset(Collection<? extends T> set) {
        Iterator<Collection<T>> it = this.subsets.iterator();
        while (it.hasNext()) {
            Collection<? extends T> s = it.next();
            if (s != set) continue;
            it.remove();
            if (this.modifyMe == set) {
                this.modifyMe = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setModifier(Collection<? extends T> set) {
        for (Collection<? extends T> collection : this.subsets) {
            if (collection != set) continue;
            this.modifyMe = set;
            return;
        }
        this.subsets.add(set);
        this.modifyMe = set;
    }

    @Override
    public int size() {
        int size = 0;
        for (Collection<T> s : this.subsets) {
            size += s.size();
        }
        return size;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SupersetIterator
    implements Iterator<T> {
        Iterator<Collection<? extends T>> subsetIterator;
        Iterator<? extends T> currentIterator;
        Collection<? extends T> currentSet;
        protected int index = 0;

        public SupersetIterator() {
            this.subsetIterator = FastSuperset.this.subsets.iterator();
            if (this.subsetIterator.hasNext()) {
                this.currentSet = this.subsetIterator.next();
                this.currentIterator = this.currentSet.iterator();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.currentIterator == null) {
                return false;
            }
            if (this.currentIterator.hasNext()) {
                return true;
            }
            while (this.subsetIterator.hasNext()) {
                this.currentSet = this.subsetIterator.next();
                ++this.index;
                this.currentIterator = this.currentSet.iterator();
                if (!this.currentIterator.hasNext()) continue;
                return true;
            }
            this.currentIterator = null;
            return false;
        }

        @Override
        public T next() {
            if (this.currentIterator != null && this.currentIterator.hasNext()) {
                try {
                    return this.currentIterator.next();
                }
                catch (ConcurrentModificationException ex) {
                    ex.printStackTrace();
                    throw ex;
                }
            }
            throw new NoSuchElementException("The iterator it empty");
        }

        @Override
        public void remove() {
            if (this.currentSet != FastSuperset.this.modifyMe) {
                throw new UnsupportedOperationException("Attempted to use iterator to modify unmodifiable set");
            }
            this.currentIterator.remove();
        }
    }
}

