/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.io.File;
import org.apache.log4j.Logger;

public class OSUtil {
    protected static final Logger logger = Logger.getLogger(OSUtil.class);

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static String getOSVersion() {
        return System.getProperty("os.version");
    }

    public static String getOSArch() {
        return System.getProperty("os.arch");
    }

    public static OS getOS() {
        String osName = OSUtil.getOSName();
        String osVersion = OSUtil.getOSVersion();
        if (osName.equalsIgnoreCase("Linux")) {
            return OS.LINUX;
        }
        if (osName.equalsIgnoreCase("Mac OS X")) {
            return OS.MAC_OS_X;
        }
        if (osName.matches("^Windows.*$")) {
            if (osName.equalsIgnoreCase("Windows Vista") || osVersion.equals("6.0")) {
                return OS.WINDOWS_VISTA;
            }
            if (osName.equalsIgnoreCase("Windows XP") || osVersion.equals("5.1")) {
                return OS.WINDOWS_XP;
            }
            if (osName.equalsIgnoreCase("Windows 2000") || osVersion.equals("5.0")) {
                return OS.WINDOWS_2000;
            }
            if (osName.equalsIgnoreCase("Windows 98") || osVersion.startsWith("4.10")) {
                return OS.WINDOWS_98;
            }
            if (osName.equalsIgnoreCase("Windows ME") || osVersion.equals("4.10")) {
                return OS.WINDOWS_ME;
            }
            if (osName.equalsIgnoreCase("SunOS")) {
                return OS.SUN;
            }
        }
        return OS.UNKNOWN;
    }

    public static boolean isLinux() {
        return OSUtil.getOS() == OS.LINUX;
    }

    public static boolean isSun() {
        return OSUtil.getOS() == OS.SUN;
    }

    public static boolean isMacOSX() {
        return OSUtil.getOS() == OS.MAC_OS_X;
    }

    public static boolean isWindowsVista() {
        return OSUtil.getOS() == OS.WINDOWS_VISTA;
    }

    public static boolean isWindowsXP() {
        return OSUtil.getOS() == OS.WINDOWS_XP;
    }

    public static boolean isWindows2000() {
        return OSUtil.getOS() == OS.WINDOWS_2000;
    }

    public static boolean isWindows98() {
        return OSUtil.getOS() == OS.WINDOWS_98;
    }

    public static boolean isWindowsME() {
        return OSUtil.getOS() == OS.WINDOWS_ME;
    }

    public static boolean isWindows() {
        return OSUtil.isWindowsVista() || OSUtil.isWindowsXP() || OSUtil.isWindows2000() || OSUtil.isWindows98() || OSUtil.isWindowsME();
    }

    public static boolean isUnix() {
        return OSUtil.isLinux() || OSUtil.isSun();
    }

    public static String getConfigDirectory(String projectName) {
        String userHome = System.getProperty("user.home");
        if (OSUtil.isUnix()) {
            return userHome + "/." + projectName.toLowerCase();
        }
        if (OSUtil.isMacOSX()) {
            return userHome + "/Library/Application Support/" + projectName;
        }
        if (OSUtil.isWindowsVista()) {
            return userHome + "\\AppData\\Roaming\\" + projectName;
        }
        if (OSUtil.isWindowsXP() || OSUtil.isWindows2000()) {
            return userHome + "\\Application Data\\" + projectName;
        }
        if (OSUtil.isWindows98() || OSUtil.isWindowsME()) {
            return File.listRoots()[0] + "\\Windows\\Application Data\\" + projectName;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OS {
        LINUX,
        MAC_OS_X,
        WINDOWS_VISTA,
        WINDOWS_XP,
        WINDOWS_2000,
        WINDOWS_98,
        WINDOWS_ME,
        SUN,
        UNKNOWN;

    }
}

