/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.bbop.util.IteratorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperIterator<IN, OUT>
implements Iterator<OUT> {
    protected static final Logger logger = Logger.getLogger(SuperIterator.class);
    protected Stack<Iterator> iteratorStack;
    protected Iterator<OUT> current;
    protected IN root;
    protected List<IteratorFactory> factories;

    public SuperIterator(IN root, IteratorFactory ... factories) {
        this.factories = new LinkedList<IteratorFactory>();
        for (IteratorFactory factory : factories) {
            this.factories.add(factory);
        }
        this.root = root;
    }

    public SuperIterator(IN root, List<IteratorFactory> factories) {
        this.factories = factories;
        this.root = root;
    }

    @Override
    public boolean hasNext() {
        this.current = this.getCurrentIterator();
        return this.current != null;
    }

    @Override
    public OUT next() {
        this.current = this.getCurrentIterator();
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.current.next();
    }

    @Override
    public void remove() {
        this.current = this.getCurrentIterator();
        this.current.remove();
    }

    protected Iterator<OUT> getCurrentIterator() {
        if (this.iteratorStack == null) {
            this.iteratorStack = new Stack();
            this.iteratorStack.push(this.factories.get(0).getIterator(this.root));
        }
        while (this.iteratorStack.size() > 0) {
            Iterator current = this.iteratorStack.peek();
            if (current.hasNext()) {
                if (this.iteratorStack.size() == this.factories.size()) break;
                Object obj = current.next();
                IteratorFactory currentFactory = this.factories.get(this.iteratorStack.size());
                Iterator newIterator = currentFactory.getIterator(obj);
                this.iteratorStack.push(newIterator);
                continue;
            }
            this.iteratorStack.pop();
        }
        if (this.iteratorStack.size() == 0) {
            return null;
        }
        return this.iteratorStack.peek();
    }
}

