/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinySet<T>
implements Set<T> {
    protected Collection<T> list;
    protected static final Iterator emptyIterator = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new RuntimeException("Cannot call next() on an empty iterator");
        }

        public void remove() {
            throw new RuntimeException("Cannot call next() on an empty iterator");
        }
    };

    protected void forceCollection() {
        if (this.list == null) {
            this.list = new ArrayList<T>(1);
        }
    }

    @Override
    public boolean add(T o) {
        this.forceCollection();
        if (!this.list.contains(o)) {
            this.list.add(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.forceCollection();
        boolean added = false;
        for (T o : c) {
            if (this.list.contains(o)) continue;
            this.list.add(o);
            added = true;
        }
        return added;
    }

    @Override
    public void clear() {
        this.list = null;
    }

    @Override
    public boolean contains(Object o) {
        if (this.list == null) {
            return false;
        }
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (this.list == null) {
            return c.size() == 0;
        }
        return this.list.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.list == null;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.list == null) {
            return emptyIterator;
        }
        return this.list.iterator();
    }

    @Override
    public boolean remove(Object o) {
        if (this.list == null) {
            return false;
        }
        if (this.list.contains(o) && this.list.size() == 1) {
            this.list = null;
            return true;
        }
        return this.list.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = false;
        for (Object o : c) {
            if (this.list.remove(o)) {
                removed = true;
            }
            if (this.list != null) continue;
            break;
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Iterator<T> it = this.iterator();
        boolean changed = false;
        while (it.hasNext()) {
            T o = it.next();
            if (c.contains(o)) continue;
            it.remove();
            changed = true;
        }
        if (this.list.size() == 0) {
            this.list = null;
        }
        return changed;
    }

    @Override
    public int size() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        Iterator<T> e = this.iterator();
        int i = 0;
        while (e.hasNext()) {
            result[i] = e.next();
            ++i;
        }
        return result;
    }

    @Override
    public <E> E[] toArray(E[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator<T> it = this.iterator();
        E[] result = a;
        for (int i = 0; i < size; ++i) {
            result[i] = it.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public String toString() {
        if (this.list == null) {
            return "[]";
        }
        return this.list.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set otherSet = (Set)other;
        if (otherSet.size() != this.size()) {
            return false;
        }
        return this.containsAll(otherSet);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (T item : this) {
            if (item == null) continue;
            hash += item.hashCode();
        }
        return hash;
    }
}

