/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.bbop.io.IOUtil;

public class XMLUtil {
    protected static final Logger logger = Logger.getLogger(XMLUtil.class);
    protected static final String INDENT_TRANSFORM = "<xsl:stylesheet  version=\"1.0\" \n                xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n   <xsl:output method=\"xml\"/>\n   <xsl:param name=\"indent-increment\" select=\"'   '\" />\n   <xsl:template match=\"*\">\n      <xsl:param name=\"indent\" select=\"'&#xA;'\"/>\n      <xsl:value-of select=\"$indent\"/>\n      <xsl:copy>\n        <xsl:copy-of select=\"@*\" />\n        <xsl:apply-templates>\n          <xsl:with-param name=\"indent\"\n               select=\"concat($indent, $indent-increment)\"/>\n        </xsl:apply-templates>\n        <xsl:if test=\"*\">\n          <xsl:value-of select=\"$indent\"/>\n        </xsl:if>\n      </xsl:copy>\n   </xsl:template>\n   <xsl:template match=\"comment()|processing-instruction()\">\n      <xsl:copy />\n   </xsl:template>\n   <!-- WARNING: this is dangerous. Handle with care -->\n   <xsl:template match=\"text()[normalize-space(.)='']\"/>\n</xsl:stylesheet>";

    private XMLUtil() {
    }

    public static String transformToString(String xslt, String xml) throws TransformerException {
        StreamSource xmlSource = new StreamSource(new StringReader(xslt));
        StreamSource xsltSource = new StreamSource(new StringReader(xml));
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        XMLUtil.transform(xsltSource, xmlSource, result, null, null);
        return writer.getBuffer().toString().trim();
    }

    public static void transform(File xslt, File xml) throws TransformerException, IOException {
        File out = File.createTempFile("transform_result", "xml");
        out.deleteOnExit();
        XMLUtil.transform(xslt, xml, out);
        IOUtil.copyFile(out, xml);
        out.delete();
    }

    public static void transform(String xslt, File xml, Map params) throws IOException, TransformerException {
        File out = File.createTempFile("transform_result", "xml");
        StreamSource xsltSource = new StreamSource(new StringReader(xslt));
        StreamSource xmlSource = new StreamSource(new FileReader(xml));
        StreamResult result = new StreamResult(new FileWriter(out));
        XMLUtil.transform(xsltSource, xmlSource, result, null, params);
        IOUtil.copyFile(out, xml);
    }

    public static void transform(File xslt, File xml, File out) throws TransformerException, IOException {
        StreamSource xmlSource = new StreamSource(new FileReader(xml));
        StreamSource xsltSource = new StreamSource(new FileReader(xslt));
        StreamResult result = new StreamResult(new FileWriter(out));
        XMLUtil.transform(xsltSource, xmlSource, result, null, null);
    }

    public static void transform(Source xsltSource, Source xmlSource, Result result, Map outputProperties, Map parameters) throws TransformerException {
        String value;
        TransformerFactory transFact = TransformerFactory.newInstance();
        Transformer trans = transFact.newTransformer(xsltSource);
        if (outputProperties != null) {
            for (String name : outputProperties.keySet()) {
                value = (String)outputProperties.get(name);
                trans.setOutputProperty(name, value);
            }
        }
        if (parameters != null) {
            for (String name : parameters.keySet()) {
                value = parameters.get(name);
                trans.setParameter(name, value);
            }
        }
        trans.transform(xmlSource, result);
    }

    public static String indentXML(String xml) {
        StreamSource xmlSource = new StreamSource(new StringReader(xml));
        StreamSource xsltSource = new StreamSource(new StringReader(INDENT_TRANSFORM));
        StringWriter writer = new StringWriter();
        try {
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("omit-xml-declaration", xml.trim().startsWith("<?xml") ? "no" : "yes");
            trans.transform(xmlSource, new StreamResult(writer));
        }
        catch (Exception ex) {
            return xml;
        }
        return writer.toString().trim();
    }
}

