/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.Model;
import org.biopax.validator.api.Validator;
import org.biopax.validator.api.ValidatorUtils;
import org.biopax.validator.api.beans.Validation;
import org.biopax.validator.api.beans.ValidatorResponse;
import org.biopax.validator.impl.IdentifierImpl;
import org.biopax.validator.utils.Normalizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.util.ResourceUtils;

public class Main {
    static final Log log = LogFactory.getLog(Main.class);
    static ApplicationContext ctx;
    static boolean autofix;
    static int maxErrors;
    static final String EXT = ".modified.owl";
    static String profile;
    static String xmlBase;
    static String outFormat;
    static String output;

    private static void setUpLogger() {
        Properties properties = new Properties();
        properties.put("log4j.rootLogger", "ERROR, Console");
        properties.put("log4j.appender.Console", "org.apache.log4j.ConsoleAppender");
        properties.put("log4j.appender.Console.layout", "org.apache.log4j.PatternLayout");
        properties.put("log4j.appender.Console.layout.ConversionPattern", "%-4r [%t] %-5p %c %x - %m%n");
        PropertyConfigurator.configure((Properties)properties);
        properties = new Properties(properties);
        try {
            properties.load(new FileReader("log4j.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load cPath2 properties from log4j.properties", e);
        }
        PropertyConfigurator.configure((Properties)properties);
    }

    public static void main(String[] args) throws Exception {
        String input;
        Main.setUpLogger();
        if (args == null || args.length == 0) {
            log.warn((Object)"At least input file/dir must be specified.");
            Main.printHelpAndQuit();
        }
        if ((input = args[0]) == null || input.isEmpty() || input.startsWith("--")) {
            log.warn((Object)"Input (file, url, or directory) is probably missing");
            Main.printHelpAndQuit();
        }
        for (int i = 1; i < args.length; ++i) {
            if ("--auto-fix".equalsIgnoreCase(args[i])) {
                autofix = true;
                continue;
            }
            if (args[i].startsWith("--max-errors=")) {
                String n = args[i].substring(13);
                maxErrors = Integer.parseInt(n);
                continue;
            }
            if (args[i].startsWith("--profile=")) {
                profile = args[i].substring(10);
                continue;
            }
            if (args[i].startsWith("--xmlBase=")) {
                xmlBase = args[i].substring(10);
                continue;
            }
            if (args[i].startsWith("--output=")) {
                output = args[i].substring(9);
                continue;
            }
            if (!args[i].startsWith("--out-format=") || !(outFormat = args[i].substring(13)).isEmpty()) continue;
            outFormat = "html";
        }
        ctx = new ClassPathXmlApplicationContext(new String[]{"META-INF/spring/appContext-loadTimeWeaving.xml", "META-INF/spring/appContext-validator.xml"});
        Validator validator = (Validator)ctx.getBean("validator");
        Main.runBatch(validator, Main.getResourcesToValidate(input));
    }

    private static void printHelpAndQuit() {
        String usage = "\nThe BioPAX Validator v3\n\nUsage (arguments):\n <input> [--output=<filename>] [--out-format=xml|html] [--auto-fix] [--xmlBase=<base>] [--max-errors=<n>] [--profile=notstrict]\n\nGiven --output=<filename>, a one-file validation report will be \ngenerated (HTML or XML) instead of default report file(s) in the \ncurrent directory. Optional arguments can go in any order.\nFor example:\n  path/dir --out-format=xml\n  list:batch_file.txt --output=reports.html\n  file:biopax.owl --out-format=xml --auto-fix\n  http://www.some.net/data.owl\n\nA batch file should list one task (resource) per line, i.e.,\nfile:path/file or URL (to BioPAX data)\nIf '--auto-fix' option was used, it also creates a new BioPAX file \nfor each input file in the current working directory \n(adding '.modified.owl' exention). If the outFormat file extension \nis '.html', the XML result will be auto-transformed to a stand-alone \nHTML/javascript page, which is very similar to what the online version returns.";
        System.out.println("\nThe BioPAX Validator v3\n\nUsage (arguments):\n <input> [--output=<filename>] [--out-format=xml|html] [--auto-fix] [--xmlBase=<base>] [--max-errors=<n>] [--profile=notstrict]\n\nGiven --output=<filename>, a one-file validation report will be \ngenerated (HTML or XML) instead of default report file(s) in the \ncurrent directory. Optional arguments can go in any order.\nFor example:\n  path/dir --out-format=xml\n  list:batch_file.txt --output=reports.html\n  file:biopax.owl --out-format=xml --auto-fix\n  http://www.some.net/data.owl\n\nA batch file should list one task (resource) per line, i.e.,\nfile:path/file or URL (to BioPAX data)\nIf '--auto-fix' option was used, it also creates a new BioPAX file \nfor each input file in the current working directory \n(adding '.modified.owl' exention). If the outFormat file extension \nis '.html', the XML result will be auto-transformed to a stand-alone \nHTML/javascript page, which is very similar to what the online version returns.");
        System.exit(-1);
    }

    protected static void runBatch(Validator validator, Collection<Resource> resources) throws IOException {
        ValidatorResponse consolidatedReport = new ValidatorResponse();
        for (Resource resource : resources) {
            Validation result = new Validation((Validation.Identifier)new IdentifierImpl(), resource.getDescription(), autofix, null, maxErrors, profile);
            result.setDescription(resource.getDescription());
            log.info((Object)("BioPAX DATA IMPORT FROM: " + result.getDescription()));
            try {
                validator.importModel(result, resource.getInputStream());
                validator.validate(result);
                if (autofix) {
                    Model model = (Model)result.getModel();
                    Normalizer normalizer = new Normalizer();
                    normalizer.setXmlBase(xmlBase);
                    normalizer.normalize(model);
                }
                if (output != null) {
                    consolidatedReport.addValidationResult(result);
                }
            }
            catch (Exception e) {
                log.error((Object)"failed", (Throwable)e);
            }
            String filename = Main.outFileName(result);
            if (autofix) {
                Model model = (Model)result.getModel();
                new SimpleIOHandler().convertToOWL(model, (OutputStream)new FileOutputStream(filename + EXT));
            }
            result.setModel(null);
            result.setModelData(null);
            if (output == null || output.isEmpty()) {
                PrintWriter writer = new PrintWriter(filename + ".validation." + outFormat);
                StreamSource xsltSrc = outFormat.equalsIgnoreCase("html") ? new StreamSource(ctx.getResource("classpath:html-result.xsl").getInputStream()) : null;
                ValidatorUtils.write((Validation)result, (Writer)writer, (Source)xsltSrc);
                writer.close();
            }
            validator.getResults().remove(result);
            log.info((Object)("Done with " + filename));
        }
        if (output != null) {
            PrintWriter writer = new PrintWriter(output);
            StreamSource xsltSrc = outFormat.equalsIgnoreCase("html") ? new StreamSource(ctx.getResource("classpath:html-result.xsl").getInputStream()) : null;
            ValidatorUtils.write((ValidatorResponse)consolidatedReport, (Writer)writer, (Source)xsltSrc);
            ((Writer)writer).close();
        }
    }

    private static String outFileName(Validation result) {
        String filename = result.getDescription();
        int idx = (filename = filename.replaceAll("\\[|\\]", "").replaceFirst("/&", "")).lastIndexOf(47);
        if (idx >= 0 && idx < filename.length() - 1) {
            filename = filename.substring(idx + 1);
        }
        return filename;
    }

    public static Collection<Resource> getResourcesToValidate(String input) throws IOException {
        HashSet<Resource> setRes = new HashSet<Resource>();
        File fileOrDir = new File(input);
        if (fileOrDir.isDirectory()) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".owl");
                }
            };
            for (String s : fileOrDir.list(filter)) {
                String uri = "file:" + fileOrDir.getCanonicalPath() + File.separator + s;
                setRes.add(ctx.getResource(uri));
            }
        } else if (input.startsWith("list:")) {
            String line;
            String batchFile = input.replaceFirst("list:", "file:");
            InputStreamReader isr = new InputStreamReader(ctx.getResource(batchFile).getInputStream());
            BufferedReader reader = new BufferedReader(isr);
            while ((line = reader.readLine()) != null && !"".equals(line.trim())) {
                if (!ResourceUtils.isUrl((String)line)) {
                    log.error((Object)("Invalid URL: " + line + ". A resource must be either a " + "pseudo URL (classpath: or file:) or standard URL!"));
                    continue;
                }
                setRes.add(ctx.getResource(line));
            }
            reader.close();
        } else {
            Resource resource = null;
            if (!ResourceUtils.isUrl((String)input)) {
                input = "file:" + input;
            }
            resource = ctx.getResource(input);
            setRes.add(resource);
        }
        return setRes;
    }

    static {
        autofix = false;
        maxErrors = 0;
        profile = null;
        xmlBase = null;
        outFormat = "html";
        output = null;
    }
}

