/*
 * Decompiled with CFR 0.152.
 */
import java.util.Properties;
import java.util.Set;
import org.biopax.psidev.ontology_manager.Ontology;
import org.biopax.psidev.ontology_manager.OntologyTermI;
import org.biopax.psidev.ontology_manager.impl.OntologyImpl;
import org.biopax.psidev.ontology_manager.impl.OntologyLoaderException;
import org.biopax.psidev.ontology_manager.impl.OntologyManagerContext;
import org.biopax.psidev.ontology_manager.impl.OntologyManagerImpl;
import org.junit.Assert;
import org.junit.Test;

public class OntologyParserTest {
    @Test
    public void ontologyLoading() throws OntologyLoaderException {
        OntologyManagerContext.getInstance().setStoreOntologiesLocally(true);
        Properties cfg = new Properties();
        cfg.put("SO", "classpath:so.obo");
        cfg.put("MI", "classpath:mi.obo");
        cfg.put("MOD", "classpath:mod.obo");
        OntologyManagerImpl manager = new OntologyManagerImpl(cfg);
        Set ontologyIDs = manager.getOntologyIDs();
        Assert.assertTrue((boolean)ontologyIDs.contains("MOD"));
        Assert.assertTrue((boolean)ontologyIDs.contains("SO"));
        Assert.assertTrue((boolean)ontologyIDs.contains("MI"));
        Ontology oa2 = manager.getOntology("MOD");
        Assert.assertNotNull((Object)oa2);
        Assert.assertTrue((boolean)(oa2 instanceof OntologyImpl));
        OntologyTermI t = oa2.getTermForAccession("MOD:00048");
        Assert.assertNotNull((Object)t);
        Assert.assertTrue((boolean)t.getPreferredName().equalsIgnoreCase("O4'-phospho-L-tyrosine"));
        oa2 = manager.getOntology("SO");
        Assert.assertNotNull((Object)oa2);
        Assert.assertTrue((boolean)(oa2 instanceof OntologyImpl));
        oa2 = manager.getOntology("MI");
        Assert.assertNotNull((Object)oa2);
        Assert.assertTrue((boolean)(oa2 instanceof OntologyImpl));
    }
}

