/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.psidev.ontology_manager.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.ols.TermRelationship;
import org.biopax.ols.TermSynonym;
import org.biopax.ols.impl.BaseOBO2AbstractLoader;
import org.biopax.ols.impl.OBO2FormatParser;
import org.biopax.ols.impl.TermBean;
import org.biopax.psidev.ontology_manager.OntologyAccess;
import org.biopax.psidev.ontology_manager.impl.OntologyAccessImpl;
import org.biopax.psidev.ontology_manager.impl.OntologyLoaderException;
import org.biopax.psidev.ontology_manager.impl.OntologyManagerContext;
import org.biopax.psidev.ontology_manager.impl.OntologyTermImpl;

public class OboLoader
extends BaseOBO2AbstractLoader {
    public static final Log log = LogFactory.getLog(OboLoader.class);
    private static final String ONTOLOGY_REGISTRY_NAME = "ontology.registry.map";

    public OntologyAccess parseOboFile(File file, String ontologyID) {
        if (!file.exists()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " doesn't exist.");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " could not be read.");
        }
        try {
            this.setParser(new OBO2FormatParser(file.getAbsolutePath()));
            this.process();
        }
        catch (Exception e) {
            log.fatal((Object)("Parse failed: " + e.getMessage()), (Throwable)e);
        }
        return this.buildOntology(ontologyID);
    }

    public OntologyAccess parseOboFile(URL url, String ontologyID) throws OntologyLoaderException {
        if (url == null) {
            throw new IllegalArgumentException("Please give a non null URL.");
        }
        File ontologyFile = null;
        File ontologyDirectory = OntologyManagerContext.getInstance().getOntologyDirectory();
        boolean isKeepDownloadedOntologiesOnDisk = OntologyManagerContext.getInstance().isStoreOntologiesLocally();
        HashMap<URL, String> registryMap = null;
        if (isKeepDownloadedOntologiesOnDisk) {
            if (ontologyDirectory == null) {
                throw new IllegalArgumentException("OntologyAccess directory cannot be null, please set it using OntologyManagerContext");
            }
            if (!ontologyDirectory.exists()) {
                throw new IllegalArgumentException("OntologyAccess directory " + ontologyDirectory.getPath() + " must exist");
            }
            if (!ontologyDirectory.canWrite()) {
                throw new IllegalArgumentException("OntologyAccess directory " + ontologyDirectory.getPath() + " must be writeable");
            }
            log.info((Object)("User work directory: " + ontologyDirectory.getAbsolutePath()));
            log.info((Object)("keepTemporaryFile: " + OntologyManagerContext.getInstance().isStoreOntologiesLocally()));
            File registryFile = this.getRegistryFile();
            if (null != registryFile) {
                try {
                    if (registryFile.length() > 0L) {
                        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(registryFile));
                        registryMap = (HashMap<URL, String>)ois.readObject();
                        if (registryMap != null) {
                            if (registryMap.containsKey(url)) {
                                ontologyFile = new File((String)registryMap.get(url));
                                if (ontologyFile.exists() && ontologyFile.canRead()) {
                                    log.info((Object)("Reuse existing cache: " + ontologyFile.getAbsolutePath()));
                                } else {
                                    log.info((Object)("Could not find " + ontologyFile.getAbsolutePath()));
                                    registryMap.remove(url);
                                    log.info((Object)"Saving registry file...");
                                    File f = this.getRegistryFile();
                                    ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
                                    oos.writeObject(registryMap);
                                    oos.flush();
                                    oos.close();
                                }
                            }
                        } else {
                            log.info((Object)"could not deserialize the Map");
                        }
                    } else {
                        log.info((Object)"The file is empty");
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Error while deserializing the map", (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)"Error while deserializing the map", (Throwable)e);
                }
            }
        }
        try {
            if (ontologyFile == null || !ontologyFile.exists() || !ontologyFile.canRead()) {
                log.info((Object)("Loading URL: " + url));
                URLConnection con = url.openConnection();
                long size = con.getContentLength();
                log.info((Object)("size = " + size));
                InputStream is = url.openStream();
                if (!ontologyDirectory.exists() && !ontologyDirectory.mkdirs()) {
                    throw new IOException("Cannot create temp directory: " + ontologyDirectory.getAbsolutePath());
                }
                String name = null;
                String filename = url.getFile();
                int idx = filename.lastIndexOf(47);
                if (idx != -1) {
                    name = filename.substring(idx + 1, filename.length());
                    name = name.replaceAll("[.,;:&^%$@*?=]", "_");
                } else {
                    name = "unknown";
                }
                ontologyFile = new File(ontologyDirectory + File.separator + name + System.currentTimeMillis() + ".obo");
                if (!isKeepDownloadedOntologiesOnDisk) {
                    log.info((Object)"Request file to be deleted on exit.");
                    ontologyFile.deleteOnExit();
                }
                log.debug((Object)("The OBO file will be temporary stored as: " + ontologyFile.getAbsolutePath()));
                FileOutputStream out = new FileOutputStream(ontologyFile);
                if (size == -1L) {
                    size = 0x40000000L;
                }
                ReadableByteChannel source = Channels.newChannel(is);
                size = out.getChannel().transferFrom(source, 0L, size);
                log.info((Object)(size + " bytes downloaded"));
                is.close();
                out.flush();
                out.close();
                if (isKeepDownloadedOntologiesOnDisk) {
                    if (registryMap == null) {
                        registryMap = new HashMap<URL, String>();
                    }
                    registryMap.put(url, ontologyFile.getAbsolutePath());
                    log.info((Object)"Serializing Map");
                    File f = this.getRegistryFile();
                    ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
                    oos.writeObject(registryMap);
                    oos.flush();
                    oos.close();
                }
            }
            if (ontologyFile == null) {
                log.error((Object)"The ontology file is still null...");
            }
            return this.parseOboFile(ontologyFile, ontologyID);
        }
        catch (IOException e) {
            throw new OntologyLoaderException("Error while loading URL (" + url + ")", e);
        }
    }

    private OntologyAccess buildOntology(String ontologyID) {
        OntologyAccessImpl ontologyAccess = new OntologyAccessImpl();
        for (TermBean termBean : this.ontBean.getTerms()) {
            if ("PSI-MOD".equals(termBean.getNamespace()) && ("PSI-MI".equals(ontologyID) || "MI".equals(ontologyID))) continue;
            OntologyTermImpl ontologyTerm = new OntologyTermImpl(ontologyID, termBean.getIdentifier(), termBean.getName());
            Collection<TermSynonym> synonyms = termBean.getSynonyms();
            if (synonyms != null) {
                for (TermSynonym synonym : synonyms) {
                    ontologyTerm.getNameSynonyms().add(synonym.getSynonym());
                }
            }
            ontologyAccess.addTerm(ontologyTerm);
            if (!termBean.isObsolete()) continue;
            ontologyAccess.addObsoleteTerm(ontologyTerm);
        }
        for (TermBean termBean : this.ontBean.getTerms()) {
            if ("PSI-MOD".equals(termBean.getNamespace()) && ("PSI-MI".equals(ontologyID) || "MI".equals(ontologyID)) || termBean.getRelationships() == null) continue;
            for (TermRelationship relation : termBean.getRelationships()) {
                try {
                    ontologyAccess.addLink(relation.getObjectTerm().getIdentifier(), relation.getSubjectTerm().getIdentifier());
                }
                catch (NullPointerException e) {
                    log.warn((Object)("Skipping terms relationship " + relation + "; " + e));
                }
            }
        }
        return ontologyAccess;
    }

    private File getRegistryFile() throws OntologyLoaderException {
        File ontologyDirectory = OntologyManagerContext.getInstance().getOntologyDirectory();
        File[] registry = ontologyDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return OboLoader.ONTOLOGY_REGISTRY_NAME.equals(pathname.getName());
            }
        });
        if (registry.length == 1) {
            File validatorRegistry = registry[0];
            return validatorRegistry;
        }
        return new File(ontologyDirectory.getAbsolutePath() + File.separator + ONTOLOGY_REGISTRY_NAME);
    }
}

