/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.psidev.ontology_manager.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.biopax.psidev.ontology_manager.OntologyTermI;

public class OntologyTermImpl
implements OntologyTermI {
    private String acc;
    private String name;
    private Collection<String> nameSynonyms;
    private String ontologyId;

    public OntologyTermImpl(String acc) {
        this.setTermAccession(acc);
    }

    public OntologyTermImpl(String ont, String acc, String name) {
        this(acc);
        this.name = name;
        this.ontologyId = ont;
    }

    @Override
    public void setTermAccession(String accession) {
        if (accession == null || accession.trim().length() == 0) {
            throw new IllegalArgumentException("You must give a non null/empty term accession");
        }
        this.acc = accession;
    }

    @Override
    public String getTermAccession() {
        return this.acc;
    }

    @Override
    public void setPreferredName(String preferredName) {
        this.name = preferredName;
    }

    @Override
    public Collection<String> getNameSynonyms() {
        if (this.nameSynonyms == null) {
            this.nameSynonyms = new ArrayList<String>();
        }
        return this.nameSynonyms;
    }

    @Override
    public void setNameSynonyms(Collection<String> nameSynonyms) {
        this.nameSynonyms = nameSynonyms;
    }

    @Override
    public String getPreferredName() {
        return this.name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OntologyTermImpl");
        sb.append("{acc='").append(this.acc).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OntologyTermImpl that = (OntologyTermImpl)o;
        return this.acc.equals(that.acc);
    }

    public int hashCode() {
        int result = this.acc.hashCode();
        return result;
    }

    @Override
    public String getOntologyId() {
        return this.ontologyId;
    }

    @Override
    public void setOntologyId(String ontologyId) {
        this.ontologyId = ontologyId;
    }
}

